/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestfulServiceRegistry
extends AbstractServiceRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulServiceRegistry.class);
    private final transient RestTemplate restTemplate;
    private final String url;
    private final MultiValueMap<String, String> headers;

    public RegisteredService save(RegisteredService registeredService) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.url, HttpMethod.POST, new HttpEntity((Object)registeredService, this.headers), RegisteredService.class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (RegisteredService)responseEntity.getBody();
        }
        return null;
    }

    public boolean delete(RegisteredService registeredService) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.url, HttpMethod.DELETE, new HttpEntity((Object)registeredService, this.headers), Integer.class, new Object[0]);
        return responseEntity.getStatusCode().is2xxSuccessful();
    }

    public List<RegisteredService> load() {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.url, HttpMethod.GET, new HttpEntity(this.headers), RegisteredService[].class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            RegisteredService[] results = (RegisteredService[])responseEntity.getBody();
            return Stream.of(results).collect(Collectors.toList());
        }
        return new ArrayList<RegisteredService>(0);
    }

    public RegisteredService findServiceById(long id) {
        String url = StringUtils.appendIfMissing((String)this.url, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(String.valueOf(id));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((Object)id, this.headers), RegisteredService.class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (RegisteredService)responseEntity.getBody();
        }
        return null;
    }

    public RegisteredService findServiceById(String id) {
        String url = StringUtils.appendIfMissing((String)this.url, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(String.valueOf(id));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((Object)id, this.headers), RegisteredService.class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (RegisteredService)responseEntity.getBody();
        }
        return null;
    }

    public long size() {
        return this.load().size();
    }

    @Generated
    public RestfulServiceRegistry(RestTemplate restTemplate, String url, MultiValueMap<String, String> headers) {
        this.restTemplate = restTemplate;
        this.url = url;
        this.headers = headers;
    }
}

