/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.BaseRestEndpointProperties;
import org.apereo.cas.services.RestfulServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlan;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration(value="restServiceRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RestServiceRegistryConfiguration
implements ServiceRegistryExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServiceRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    @ConditionalOnProperty(name={"cas.serviceRegistry.rest.url"})
    public ServiceRegistry restfulServiceRegistry() {
        BaseRestEndpointProperties registry = this.casProperties.getServiceRegistry().getRest();
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        if (StringUtils.isNotBlank((CharSequence)registry.getBasicAuthUsername()) && StringUtils.isNotBlank((CharSequence)registry.getBasicAuthPassword())) {
            headers.putAll((Map)HttpUtils.createBasicAuthHeaders((String)registry.getBasicAuthUsername(), (String)registry.getBasicAuthPassword()));
        }
        return new RestfulServiceRegistry(restTemplate, registry.getUrl(), (MultiValueMap<String, String>)headers);
    }

    public void configureServiceRegistry(ServiceRegistryExecutionPlan plan) {
        BaseRestEndpointProperties registry = this.casProperties.getServiceRegistry().getRest();
        if (StringUtils.isNotBlank((CharSequence)registry.getUrl())) {
            plan.registerServiceRegistry(this.restfulServiceRegistry());
        }
    }
}

