/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.BaseRestEndpointProperties;
import org.apereo.cas.services.RestfulServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlan;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.util.HttpUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration(value="restServiceRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RestServiceRegistryConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @Bean
    @RefreshScope
    @ConditionalOnProperty(name={"cas.serviceRegistry.rest.url"})
    public ServiceRegistry restfulServiceRegistry() {
        BaseRestEndpointProperties registry = this.casProperties.getServiceRegistry().getRest();
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        if (StringUtils.isNotBlank((CharSequence)registry.getBasicAuthUsername()) && StringUtils.isNotBlank((CharSequence)registry.getBasicAuthPassword())) {
            headers.putAll((Map)HttpUtils.createBasicAuthHeaders((String)registry.getBasicAuthUsername(), (String)registry.getBasicAuthPassword()));
        }
        return new RestfulServiceRegistry(this.eventPublisher, restTemplate, registry.getUrl(), (MultiValueMap<String, String>)headers);
    }

    @Bean
    @ConditionalOnMissingBean(name={"restfulServiceRegistryExecutionPlanConfigurer"})
    public ServiceRegistryExecutionPlanConfigurer restfulServiceRegistryExecutionPlanConfigurer() {
        return new ServiceRegistryExecutionPlanConfigurer(){

            public void configureServiceRegistry(ServiceRegistryExecutionPlan plan) {
                BaseRestEndpointProperties registry = RestServiceRegistryConfiguration.this.casProperties.getServiceRegistry().getRest();
                if (StringUtils.isNotBlank((CharSequence)registry.getUrl())) {
                    plan.registerServiceRegistry(RestServiceRegistryConfiguration.this.restfulServiceRegistry());
                }
            }
        };
    }
}

