/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestfulServiceRegistry
extends AbstractServiceRegistry {
    private final transient RestTemplate restTemplate;
    private final String url;
    private final MultiValueMap<String, String> headers;

    public RestfulServiceRegistry(ApplicationEventPublisher eventPublisher, RestTemplate restTemplate, String url, MultiValueMap<String, String> headers) {
        super(eventPublisher);
        this.restTemplate = restTemplate;
        this.url = url;
        this.headers = headers;
    }

    public RegisteredService save(RegisteredService registeredService) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.url, HttpMethod.POST, new HttpEntity((Object)registeredService, this.headers), RegisteredService.class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (RegisteredService)responseEntity.getBody();
        }
        return null;
    }

    public boolean delete(RegisteredService registeredService) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.url, HttpMethod.DELETE, new HttpEntity((Object)registeredService, this.headers), Integer.class, new Object[0]);
        return responseEntity.getStatusCode().is2xxSuccessful();
    }

    public Collection<RegisteredService> load() {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.url, HttpMethod.GET, new HttpEntity(this.headers), RegisteredService[].class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            RegisteredService[] results = (RegisteredService[])responseEntity.getBody();
            return Stream.of(results).collect(Collectors.toList());
        }
        return new ArrayList<RegisteredService>(0);
    }

    public RegisteredService findServiceById(long id) {
        String completeUrl = StringUtils.appendIfMissing((String)this.url, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(String.valueOf(id));
        ResponseEntity responseEntity = this.restTemplate.exchange(completeUrl, HttpMethod.GET, new HttpEntity((Object)id, this.headers), RegisteredService.class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (RegisteredService)responseEntity.getBody();
        }
        return null;
    }

    public RegisteredService findServiceById(String id) {
        String completeUrl = StringUtils.appendIfMissing((String)this.url, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(String.valueOf(id));
        ResponseEntity responseEntity = this.restTemplate.exchange(completeUrl, HttpMethod.GET, new HttpEntity((Object)id, this.headers), RegisteredService.class, new Object[0]);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (RegisteredService)responseEntity.getBody();
        }
        return null;
    }

    public long size() {
        return this.load().size();
    }
}

