/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.resources;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.rest.BadRestRequestException;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.TicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.support.rest.resources.RestResourceUtils;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ticketResourceRestController")
public class TicketGrantingTicketResource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketResource.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final RestHttpRequestCredentialFactory credentialFactory;
    private final CentralAuthenticationService centralAuthenticationService;
    private final ServiceFactory serviceFactory;
    private final TicketGrantingTicketResourceEntityResponseFactory ticketGrantingTicketResourceEntityResponseFactory;

    @PostMapping(value={"/v1/tickets"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createTicketGrantingTicket(@RequestBody(required=false) MultiValueMap<String, String> requestBody, HttpServletRequest request) {
        try {
            TicketGrantingTicket tgtId = this.createTicketGrantingTicketForRequest(requestBody, request);
            return this.createResponseEntityForTicket(request, tgtId);
        }
        catch (AuthenticationException e) {
            return RestResourceUtils.createResponseEntityForAuthnFailure(e);
        }
        catch (BadRestRequestException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/v1/tickets/{tgtId:.+}"})
    public ResponseEntity<String> deleteTicketGrantingTicket(@PathVariable(value="tgtId") String tgtId) {
        this.centralAuthenticationService.destroyTicketGrantingTicket(tgtId);
        return new ResponseEntity((Object)tgtId, HttpStatus.OK);
    }

    protected ResponseEntity<String> createResponseEntityForTicket(HttpServletRequest request, TicketGrantingTicket tgtId) throws Exception {
        return this.ticketGrantingTicketResourceEntityResponseFactory.build(tgtId, request);
    }

    protected TicketGrantingTicket createTicketGrantingTicketForRequest(MultiValueMap<String, String> requestBody, HttpServletRequest request) {
        List credential = this.credentialFactory.fromRequest(request, requestBody);
        if (credential == null || credential.isEmpty()) {
            throw new BadRestRequestException("No credentials are provided or extracted to authenticate the REST request");
        }
        Service service = this.serviceFactory.createService(request);
        AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(service, (Collection)credential);
        return this.centralAuthenticationService.createTicketGrantingTicket(authenticationResult);
    }

    @Generated
    public TicketGrantingTicketResource(AuthenticationSystemSupport authenticationSystemSupport, RestHttpRequestCredentialFactory credentialFactory, CentralAuthenticationService centralAuthenticationService, ServiceFactory serviceFactory, TicketGrantingTicketResourceEntityResponseFactory ticketGrantingTicketResourceEntityResponseFactory) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.credentialFactory = credentialFactory;
        this.centralAuthenticationService = centralAuthenticationService;
        this.serviceFactory = serviceFactory;
        this.ticketGrantingTicketResourceEntityResponseFactory = ticketGrantingTicketResourceEntityResponseFactory;
    }
}

