/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.resources;

import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ticketStatusResourceRestController")
public class TicketStatusResource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketStatusResource.class);
    private final CentralAuthenticationService centralAuthenticationService;

    @GetMapping(value={"/v1/tickets/{id:.+}"})
    public ResponseEntity<String> getTicketStatus(@PathVariable(value="id") String id) {
        try {
            Ticket ticket = this.centralAuthenticationService.getTicket(id);
            return new ResponseEntity((Object)ticket.getId(), HttpStatus.OK);
        }
        catch (InvalidTicketException e) {
            return new ResponseEntity((Object)"Ticket could not be found", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Generated
    public TicketStatusResource(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }
}

