/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.rest.audit.RestResponseEntityAuditResourceResolver;
import org.apereo.cas.rest.factory.CasProtocolServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.ChainingRestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.CompositeServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.DefaultTicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.DefaultUserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.ServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.TicketGrantingTicketResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.rest.plan.DefaultServiceTicketResourceEntityResponseFactoryPlan;
import org.apereo.cas.rest.plan.RestHttpRequestCredentialFactoryConfigurer;
import org.apereo.cas.rest.plan.ServiceTicketResourceEntityResponseFactoryConfigurer;
import org.apereo.cas.rest.plan.ServiceTicketResourceEntityResponseFactoryPlan;
import org.apereo.cas.support.rest.resources.ServiceTicketResource;
import org.apereo.cas.support.rest.resources.TicketGrantingTicketResource;
import org.apereo.cas.support.rest.resources.TicketStatusResource;
import org.apereo.cas.support.rest.resources.UserAuthenticationResource;
import org.apereo.cas.throttle.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="casRestConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasRestConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasRestConfiguration.class);
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="argumentExtractor")
    private ObjectProvider<ArgumentExtractor> argumentExtractor;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public TicketStatusResource ticketStatusResource() {
        return new TicketStatusResource((CentralAuthenticationService)this.centralAuthenticationService.getObject());
    }

    @Bean
    @Autowired
    public ServiceTicketResource serviceTicketResource(@Qualifier(value="serviceTicketResourceEntityResponseFactory") ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory, @Qualifier(value="restHttpRequestCredentialFactory") RestHttpRequestCredentialFactory restHttpRequestCredentialFactory) {
        return new ServiceTicketResource((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject(), (TicketRegistrySupport)this.ticketRegistrySupport.getObject(), (ArgumentExtractor)this.argumentExtractor.getObject(), serviceTicketResourceEntityResponseFactory, restHttpRequestCredentialFactory, this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"serviceTicketResourceEntityResponseFactory"})
    @Autowired
    public ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory(List<ServiceTicketResourceEntityResponseFactoryConfigurer> configurers) {
        DefaultServiceTicketResourceEntityResponseFactoryPlan plan = new DefaultServiceTicketResourceEntityResponseFactoryPlan();
        configurers.forEach(c -> c.configureEntityResponseFactory((ServiceTicketResourceEntityResponseFactoryPlan)plan));
        return new CompositeServiceTicketResourceEntityResponseFactory(plan.getFactories());
    }

    @Bean
    @ConditionalOnMissingBean(name={"ticketGrantingTicketResourceEntityResponseFactory"})
    public TicketGrantingTicketResourceEntityResponseFactory ticketGrantingTicketResourceEntityResponseFactory() {
        return new DefaultTicketGrantingTicketResourceEntityResponseFactory();
    }

    @Bean
    @ConditionalOnMissingBean(name={"userAuthenticationResourceEntityResponseFactory"})
    public UserAuthenticationResourceEntityResponseFactory userAuthenticationResourceEntityResponseFactory() {
        return new DefaultUserAuthenticationResourceEntityResponseFactory();
    }

    @Autowired
    @Bean
    public TicketGrantingTicketResource ticketResourceRestController(@Qualifier(value="restHttpRequestCredentialFactory") RestHttpRequestCredentialFactory restHttpRequestCredentialFactory) {
        return new TicketGrantingTicketResource((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject(), restHttpRequestCredentialFactory, (CentralAuthenticationService)this.centralAuthenticationService.getObject(), (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.ticketGrantingTicketResourceEntityResponseFactory(), this.applicationContext);
    }

    @Autowired
    @Bean
    public UserAuthenticationResource userAuthenticationRestController(@Qualifier(value="restHttpRequestCredentialFactory") RestHttpRequestCredentialFactory restHttpRequestCredentialFactory) {
        return new UserAuthenticationResource((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject(), restHttpRequestCredentialFactory, (ServiceFactory)this.webApplicationServiceFactory.getObject(), this.userAuthenticationResourceEntityResponseFactory(), this.applicationContext);
    }

    @Autowired
    @Bean
    public RestHttpRequestCredentialFactory restHttpRequestCredentialFactory(List<RestHttpRequestCredentialFactoryConfigurer> configurers) {
        LOGGER.trace("building REST credential factory from [{}]", configurers);
        ChainingRestHttpRequestCredentialFactory factory = new ChainingRestHttpRequestCredentialFactory(new RestHttpRequestCredentialFactory[0]);
        configurers.forEach(c -> {
            LOGGER.trace("Configuring credential factory: [{}]", c);
            c.configureCredentialFactory(factory);
        });
        return factory;
    }

    @Bean
    public RestHttpRequestCredentialFactoryConfigurer restHttpRequestCredentialFactoryConfigurer() {
        return factory -> factory.registerCredentialFactory((RestHttpRequestCredentialFactory)new UsernamePasswordRestHttpRequestCredentialFactory());
    }

    @Bean
    public ServiceTicketResourceEntityResponseFactoryConfigurer restServiceTicketResourceEntityResponseFactoryConfigurer() {
        return plan -> plan.registerFactory((ServiceTicketResourceEntityResponseFactory)new CasProtocolServiceTicketResourceEntityResponseFactory((CentralAuthenticationService)this.centralAuthenticationService.getObject()));
    }

    @Bean
    public AuditTrailRecordResolutionPlanConfigurer restAuditTrailRecordResolutionPlanConfigurer() {
        return plan -> {
            plan.registerAuditActionResolver("REST_API_TICKET_GRANTING_TICKET_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_FAILED"));
            plan.registerAuditResourceResolver("REST_API_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", (AuditResourceResolver)new RestResponseEntityAuditResourceResolver(false));
            plan.registerAuditActionResolver("REST_API_SERVICE_TICKET_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_FAILED"));
            plan.registerAuditResourceResolver("REST_API_SERVICE_TICKET_RESOURCE_RESOLVER", (AuditResourceResolver)new RestResponseEntityAuditResourceResolver(true));
        };
    }

    @Configuration(value="casRestThrottlingConfiguration")
    @ConditionalOnMissingBean(name={"restAuthenticationThrottle"})
    public static class CasRestThrottlingConfiguration
    implements WebMvcConfigurer {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(CasRestThrottlingConfiguration.class);
        @Autowired
        @Qualifier(value="authenticationThrottlingExecutionPlan")
        private ObjectProvider<AuthenticationThrottlingExecutionPlan> authenticationThrottlingExecutionPlan;

        public void addInterceptors(InterceptorRegistry registry) {
            AuthenticationThrottlingExecutionPlan plan = (AuthenticationThrottlingExecutionPlan)this.authenticationThrottlingExecutionPlan.getObject();
            LOGGER.debug("Activating authentication throttling for REST endpoints...");
            plan.getAuthenticationThrottleInterceptors().forEach(handler -> registry.addInterceptor(handler).addPathPatterns(new String[]{"/v1/**"}));
        }
    }
}

