/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.config;

import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.googleapps.GoogleAppsProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.authentication.principal.GoogleAccountsServiceFactory;
import org.apereo.cas.support.saml.authentication.principal.GoogleAccountsServiceResponseBuilder;
import org.apereo.cas.support.saml.util.GoogleSaml20ObjectBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(value="samlGoogleAppsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SamlGoogleAppsConfiguration
implements ServiceFactoryConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlGoogleAppsConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean openSamlConfigBean;
    @Autowired
    private CasConfigurationProperties casProperties;

    public Collection<ServiceFactory<? extends WebApplicationService>> buildServiceFactories() {
        return CollectionUtils.wrap((Object)this.googleAccountsServiceFactory());
    }

    @ConditionalOnMissingBean(name={"googleAccountsServiceFactory"})
    @Bean
    @RefreshScope
    public ServiceFactory googleAccountsServiceFactory() {
        return new GoogleAccountsServiceFactory(this.googleSaml20ObjectBuilder());
    }

    @ConditionalOnMissingBean(name={"googleSaml20ObjectBuilder"})
    @Bean
    public GoogleSaml20ObjectBuilder googleSaml20ObjectBuilder() {
        return new GoogleSaml20ObjectBuilder(this.openSamlConfigBean);
    }

    @ConditionalOnMissingBean(name={"googleAccountsServiceResponseBuilder"})
    @Bean
    @Lazy
    public ResponseBuilder googleAccountsServiceResponseBuilder() {
        GoogleAppsProperties gApps = this.casProperties.getGoogleApps();
        return new GoogleAccountsServiceResponseBuilder(gApps.getPrivateKeyLocation(), gApps.getPublicKeyLocation(), gApps.getKeyAlgorithm(), this.servicesManager, this.googleSaml20ObjectBuilder(), this.casProperties.getSamlCore().getSkewAllowance(), this.casProperties.getServer().getPrefix());
    }
}

