/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdPSingleLogoutServiceLogoutUrlBuilder
extends DefaultSingleLogoutServiceLogoutUrlBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSingleLogoutServiceLogoutUrlBuilder.class);
    protected ServicesManager servicesManager;
    protected SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver;

    public SamlIdPSingleLogoutServiceLogoutUrlBuilder(ServicesManager servicesManager, SamlRegisteredServiceCachingMetadataResolver resolver, UrlValidator urlValidator) {
        super(urlValidator);
        this.servicesManager = servicesManager;
        this.samlRegisteredServiceCachingMetadataResolver = resolver;
    }

    public Collection<URL> determineLogoutUrl(RegisteredService registeredService, WebApplicationService singleLogoutService) {
        try {
            URL location;
            if (registeredService instanceof SamlRegisteredService && (location = this.buildLogoutUrl(registeredService, singleLogoutService)) != null) {
                LOGGER.info("Final logout URL built for [{}] is [{}]", (Object)registeredService, (Object)location);
                return CollectionUtils.wrap((Object)location);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.debug("Service [{}] is not a SAML service, or its logout url could not be determined", (Object)registeredService);
        return super.determineLogoutUrl(registeredService, singleLogoutService);
    }

    private URL buildLogoutUrl(RegisteredService registeredService, WebApplicationService singleLogoutService) throws Exception {
        LOGGER.debug("Building logout url for SAML service [{}]", (Object)registeredService);
        String entityID = singleLogoutService.getId();
        LOGGER.debug("Located entity id [{}]", (Object)entityID);
        Optional adaptor = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)((SamlRegisteredService)SamlRegisteredService.class.cast(registeredService)), (String)entityID);
        if (!adaptor.isPresent()) {
            LOGGER.warn("Cannot find metadata linked to [{}]", (Object)entityID);
            return null;
        }
        String location = ((SamlRegisteredServiceServiceProviderMetadataFacade)adaptor.get()).getSingleLogoutService().getLocation();
        return new URL(location);
    }
}

