/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.Generated;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataExpirationPolicy;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataResolverCacheLoader;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceDefaultCachingMetadataResolver
implements SamlRegisteredServiceCachingMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceDefaultCachingMetadataResolver.class);
    private static final int MAX_CACHE_SIZE = 10000;
    private final SamlRegisteredServiceMetadataResolverCacheLoader chainingMetadataResolverCacheLoader;
    private final LoadingCache<SamlRegisteredServiceCacheKey, MetadataResolver> cache;

    public SamlRegisteredServiceDefaultCachingMetadataResolver(long metadataCacheExpirationMinutes, SamlRegisteredServiceMetadataResolverCacheLoader loader) {
        this.chainingMetadataResolverCacheLoader = loader;
        this.cache = Caffeine.newBuilder().maximumSize(10000L).expireAfter((Expiry)new SamlRegisteredServiceMetadataExpirationPolicy(metadataCacheExpirationMinutes)).build((CacheLoader)this.chainingMetadataResolverCacheLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataResolver resolve(SamlRegisteredService service) {
        MetadataResolver resolver = null;
        try {
            LOGGER.debug("Resolving metadata for [{}] at [{}].", (Object)service.getName(), (Object)service.getMetadataLocation());
            SamlRegisteredServiceCacheKey k = new SamlRegisteredServiceCacheKey(service);
            LOGGER.debug("Locating cached metadata resolver using key [{}] for service [{}]", (Object)k.getId(), (Object)service.getName());
            MetadataResolver metadataResolver = resolver = (MetadataResolver)this.cache.get((Object)k);
            return metadataResolver;
        }
        finally {
            if (resolver != null) {
                LOGGER.debug("Loaded and cached SAML metadata [{}] from [{}]", (Object)resolver.getId(), (Object)service.getMetadataLocation());
            }
        }
    }
}

