/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.plan.SamlRegisteredServiceMetadataResolutionPlan;
import org.apereo.cas.util.http.HttpClient;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceMetadataResolverCacheLoader
implements CacheLoader<SamlRegisteredServiceCacheKey, MetadataResolver> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceMetadataResolverCacheLoader.class);
    @Generated
    private final Object $lock = new Object[0];
    protected OpenSamlConfigBean configBean;
    protected HttpClient httpClient;
    private final SamlRegisteredServiceMetadataResolutionPlan metadataResolutionPlan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainingMetadataResolver load(SamlRegisteredServiceCacheKey cacheKey) {
        Object object = this.$lock;
        synchronized (object) {
            ChainingMetadataResolver metadataResolver = new ChainingMetadataResolver();
            ArrayList metadataResolvers = new ArrayList();
            SamlRegisteredService service = cacheKey.getRegisteredService();
            Collection<SamlRegisteredServiceMetadataResolver> availableResolvers = this.metadataResolutionPlan.getRegisteredMetadataResolvers();
            LOGGER.debug("There are [{}] metadata resolver(s) available in the chain", (Object)availableResolvers.size());
            availableResolvers.stream().filter(Objects::nonNull).filter(r -> {
                LOGGER.debug("Evaluating whether metadata resolver [{}] can support service [{}]", (Object)r.getName(), (Object)service.getName());
                return r.supports(service);
            }).map(r -> {
                LOGGER.debug("Metadata resolver [{}] has started to process metadata for [{}]", (Object)r.getName(), (Object)service.getName());
                return r.resolve(service);
            }).forEach(metadataResolvers::addAll);
            if (metadataResolvers.isEmpty()) {
                throw new SamlException("No metadata resolvers could be configured for service " + service.getName() + " with metadata location " + service.getMetadataLocation());
            }
            metadataResolver.setId(ChainingMetadataResolver.class.getCanonicalName());
            LOGGER.debug("There are [{}] eligible metadata resolver(s) for this request", (Object)availableResolvers.size());
            metadataResolver.setResolvers(metadataResolvers);
            metadataResolver.initialize();
            LOGGER.debug("Metadata resolvers active for this request are [{}]", (Object)metadataResolver);
            return metadataResolver;
        }
    }

    @Generated
    public SamlRegisteredServiceMetadataResolverCacheLoader(OpenSamlConfigBean configBean, HttpClient httpClient, SamlRegisteredServiceMetadataResolutionPlan metadataResolutionPlan) {
        this.configBean = configBean;
        this.httpClient = httpClient;
        this.metadataResolutionPlan = metadataResolutionPlan;
    }
}

