/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClasspathResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathResourceMetadataResolver.class);

    public ClasspathResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<MetadataResolver> resolve(SamlRegisteredService service) {
        String metadataLocation = service.getMetadataLocation();
        LOGGER.info("Loading SAML metadata from [{}]", (Object)metadataLocation);
        try (InputStream in = ResourceUtils.getResourceFrom((String)metadataLocation).getInputStream();){
            LOGGER.debug("Parsing metadata from [{}]", (Object)metadataLocation);
            Document document = this.configBean.getParserPool().parse(in);
            Element metadataRoot = document.getDocumentElement();
            DOMMetadataResolver metadataProvider = new DOMMetadataResolver(metadataRoot);
            this.configureAndInitializeSingleMetadataResolver((AbstractMetadataResolver)metadataProvider, service);
            List list = CollectionUtils.wrap((Object)metadataProvider);
            return list;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ArrayList<MetadataResolver>(0);
        }
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        try {
            String metadataLocation = service.getMetadataLocation();
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            return metadataResource instanceof ClassPathResource;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

