/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.UrlResourceMetadataResolver;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.HttpUtils;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DynamicMetadataResolver
extends UrlResourceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicMetadataResolver.class);

    public DynamicMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    @Override
    protected String getMetadataLocationForService(SamlRegisteredService service) {
        LOGGER.info("Getting metadata dynamically for [{}]", (Object)service.getName());
        return service.getMetadataLocation().replace("{0}", EncodingUtils.urlEncode((String)service.getServiceId()));
    }

    @Override
    protected HttpResponse fetchMetadata(String metadataLocation) {
        SamlIdPMetadataProperties metadata = this.samlIdPProperties.getMetadata();
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        headers.put("Content-Type", metadata.getSupportedContentTypes());
        headers.put("Accept", "*/*");
        return HttpUtils.executeGet((String)metadataLocation, (String)metadata.getBasicAuthnUsername(), (String)this.samlIdPProperties.getMetadata().getBasicAuthnPassword(), new LinkedHashMap(), headers);
    }

    protected boolean isDynamicMetadataQueryConfigured(SamlRegisteredService service) {
        return service.getMetadataLocation().trim().endsWith("/entities/{0}");
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        return this.isDynamicMetadataQueryConfigured(service);
    }

    @Override
    protected boolean shouldHttpResponseStatusBeProcessed(HttpStatus status) {
        return super.shouldHttpResponseStatusBeProcessed(status) || status == HttpStatus.NOT_MODIFIED;
    }

    @Override
    protected AbstractMetadataResolver getMetadataResolverFromResponse(HttpResponse response, File backupFile) throws Exception {
        if (response.getStatusLine().getStatusCode() == HttpStatus.NOT_MODIFIED.value()) {
            return new InMemoryResourceMetadataResolver(backupFile, this.configBean);
        }
        InputStream ins = response.getEntity().getContent();
        byte[] source = ByteStreams.toByteArray((InputStream)ins);
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        return new InMemoryResourceMetadataResolver((InputStream)bais, this.configBean);
    }
}

