/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.CanWriteFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;

public class UrlResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlResourceMetadataResolver.class);
    private final File metadataBackupDirectory;

    public UrlResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
        SamlIdPMetadataProperties md = samlIdPProperties.getMetadata();
        this.metadataBackupDirectory = new File(md.getLocation().getFile(), "metadata-backups");
        try {
            FileUtils.forceMkdir((File)this.metadataBackupDirectory);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create metadata backup directory [{}] to store downloaded metadata. This is likely due to a permission issue", (Object)this.metadataBackupDirectory);
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MetadataResolver> resolve(SamlRegisteredService service) {
        HttpResponse response = null;
        try {
            HttpStatus status;
            String metadataLocation = this.getMetadataLocationForService(service);
            LOGGER.info("Loading SAML metadata from [{}]", (Object)metadataLocation);
            UrlResource metadataResource = new UrlResource(metadataLocation);
            File backupFile = this.getMetadataBackupFile((AbstractResource)metadataResource, (RegisteredService)service);
            String canonicalPath = backupFile.getCanonicalPath();
            LOGGER.debug("Metadata backup file will be at [{}]", (Object)canonicalPath);
            FileUtils.forceMkdirParent((File)backupFile);
            response = this.fetchMetadata(metadataLocation);
            this.cleanUpExpiredBackupMetadataFilesFor((AbstractResource)metadataResource, service);
            if (response != null && this.shouldHttpResponseStatusBeProcessed(status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode()))) {
                AbstractMetadataResolver metadataProvider = this.getMetadataResolverFromResponse(response, backupFile);
                this.configureAndInitializeSingleMetadataResolver(metadataProvider, service);
                List list = CollectionUtils.wrap((Object)metadataProvider);
                HttpUtils.close((HttpResponse)response);
                return list;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return new ArrayList<MetadataResolver>(0);
    }

    protected boolean shouldHttpResponseStatusBeProcessed(HttpStatus status) {
        return status.is2xxSuccessful();
    }

    protected AbstractMetadataResolver getMetadataResolverFromResponse(HttpResponse response, File backupFile) throws Exception {
        String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        try (BufferedWriter output = Files.newBufferedWriter(backupFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            IOUtils.write((String)result, (Writer)output);
            ((Writer)output).flush();
        }
        return new InMemoryResourceMetadataResolver(backupFile, this.configBean);
    }

    protected HttpResponse fetchMetadata(String metadataLocation) {
        LOGGER.debug("Fetching metadata from [{}]", (Object)metadataLocation);
        return HttpUtils.executeGet((String)metadataLocation, new LinkedHashMap());
    }

    protected String getMetadataLocationForService(SamlRegisteredService service) {
        return service.getMetadataLocation();
    }

    private void cleanUpExpiredBackupMetadataFilesFor(AbstractResource metadataResource, SamlRegisteredService service) {
        String prefix = this.getBackupMetadataFilenamePrefix(metadataResource, (RegisteredService)service);
        Collection backups = FileUtils.listFiles((File)this.metadataBackupDirectory, (IOFileFilter)new AndFileFilter(CollectionUtils.wrapList((Object[])new IOFileFilter[]{new PrefixFileFilter(prefix, IOCase.INSENSITIVE), new SuffixFileFilter(".xml", IOCase.INSENSITIVE), CanWriteFileFilter.CAN_WRITE, CanReadFileFilter.CAN_READ})), (IOFileFilter)TrueFileFilter.INSTANCE);
        backups.forEach(file -> {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to delete metadata backup file [{}]", file);
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        });
    }

    protected File getMetadataBackupFile(AbstractResource metadataResource, RegisteredService service) throws IOException {
        LOGGER.debug("Metadata backup directory is at [{}]", (Object)this.metadataBackupDirectory.getCanonicalPath());
        String metadataFileName = this.getBackupMetadataFilenamePrefix(metadataResource, service).concat(this.getBackupMetadataFilenameSuffix(metadataResource, service));
        File backupFile = new File(this.metadataBackupDirectory, metadataFileName);
        if (backupFile.exists()) {
            LOGGER.warn("Metadata file designated for service [{}] already exists at path [{}].", (Object)service.getName(), (Object)backupFile.getCanonicalPath());
        } else {
            LOGGER.debug("Metadata to fetch for service [{}] will be placed at [{}]", (Object)service.getName(), (Object)backupFile.getCanonicalPath());
        }
        return backupFile;
    }

    private String getBackupMetadataFilenameSuffix(AbstractResource metadataResource, RegisteredService service) {
        return UUID.randomUUID().toString() + ".xml";
    }

    private String getBackupMetadataFilenamePrefix(AbstractResource metadataResource, RegisteredService service) {
        return service.getName().concat("-").concat(String.valueOf(service.getId())).concat("-").concat(metadataResource.getFilename()).concat("-");
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        try {
            String metadataLocation = this.getMetadataLocationForService(service);
            return StringUtils.isNotBlank((CharSequence)metadataLocation) && StringUtils.startsWith((CharSequence)metadataLocation, (CharSequence)"http");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

