/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.util.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceCacheKey
implements Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceCacheKey.class);
    private static final long serialVersionUID = -7238573226470492601L;
    private final String id;
    private final SamlRegisteredService registeredService;

    public SamlRegisteredServiceCacheKey(SamlRegisteredService registeredService) {
        this.id = SamlRegisteredServiceCacheKey.buildRegisteredServiceCacheKey(registeredService);
        this.registeredService = registeredService;
    }

    public static String buildRegisteredServiceCacheKey(SamlRegisteredService service) {
        String key = String.valueOf(service.getId()).concat("@").concat(service.getName());
        LOGGER.debug("Determined cache key for service [{}] as [{}]", (Object)service.getName(), (Object)key);
        String hashedKey = DigestUtils.sha512((String)key);
        LOGGER.debug("Hashed service cache key as [{}]", (Object)hashedKey);
        return hashedKey;
    }

    @Generated
    public String toString() {
        return "SamlRegisteredServiceCacheKey(id=" + this.id + ", registeredService=" + this.registeredService + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SamlRegisteredServiceCacheKey)) {
            return false;
        }
        SamlRegisteredServiceCacheKey other = (SamlRegisteredServiceCacheKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SamlRegisteredServiceCacheKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public SamlRegisteredService getRegisteredService() {
        return this.registeredService;
    }
}

