/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlMetadataDocument;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.SamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.ResourceUtils;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.impl.EntityRoleFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.PredicateFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.RequiredValidUntilFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public abstract class BaseSamlRegisteredServiceMetadataResolver
implements SamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSamlRegisteredServiceMetadataResolver.class);
    protected final SamlIdPProperties samlIdPProperties;
    protected final OpenSamlConfigBean configBean;

    protected AbstractMetadataResolver buildMetadataResolverFrom(SamlRegisteredService service, SamlMetadataDocument metadataDocument) {
        try {
            String desc = org.apache.commons.lang3.StringUtils.defaultString((String)service.getDescription(), (String)service.getName());
            InputStreamResource metadataResource = ResourceUtils.buildInputStreamResourceFrom((String)metadataDocument.getValue(), (String)desc);
            InMemoryResourceMetadataResolver metadataResolver = new InMemoryResourceMetadataResolver((Resource)metadataResource, this.configBean);
            ArrayList<MetadataFilter> metadataFilterList = new ArrayList<MetadataFilter>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)metadataDocument.getSignature())) {
                InputStreamResource signatureResource = ResourceUtils.buildInputStreamResourceFrom((String)metadataDocument.getSignature(), (String)desc);
                this.buildSignatureValidationFilterIfNeeded(service, metadataFilterList, (Resource)signatureResource);
            }
            this.configureAndInitializeSingleMetadataResolver((AbstractMetadataResolver)metadataResolver, service, metadataFilterList);
            return metadataResolver;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void configureAndInitializeSingleMetadataResolver(AbstractMetadataResolver metadataProvider, SamlRegisteredService service, List<MetadataFilter> metadataFilterList) throws Exception {
        SamlIdPMetadataProperties md = this.samlIdPProperties.getMetadata();
        metadataProvider.setParserPool(this.configBean.getParserPool());
        metadataProvider.setFailFastInitialization(md.isFailFast());
        metadataProvider.setRequireValidMetadata(md.isRequireValidMetadata());
        metadataProvider.setId(metadataProvider.getClass().getCanonicalName());
        this.buildMetadataFilters(service, metadataProvider, metadataFilterList);
        LOGGER.debug("Initializing metadata resolver from [{}]", (Object)service.getMetadataLocation());
        metadataProvider.initialize();
        LOGGER.info("Initialized metadata resolver from [{}]", (Object)service.getMetadataLocation());
    }

    protected void configureAndInitializeSingleMetadataResolver(AbstractMetadataResolver metadataProvider, SamlRegisteredService service) throws Exception {
        this.configureAndInitializeSingleMetadataResolver(metadataProvider, service, new ArrayList<MetadataFilter>());
    }

    protected void buildMetadataFilters(SamlRegisteredService service, AbstractMetadataResolver metadataProvider, List<MetadataFilter> metadataFilterList) throws Exception {
        this.buildRequiredValidUntilFilterIfNeeded(service, metadataFilterList);
        this.buildSignatureValidationFilterIfNeeded(service, metadataFilterList);
        BaseSamlRegisteredServiceMetadataResolver.buildEntityRoleFilterIfNeeded(service, metadataFilterList);
        BaseSamlRegisteredServiceMetadataResolver.buildPredicateFilterIfNeeded(service, metadataFilterList);
        if (!metadataFilterList.isEmpty()) {
            this.addMetadataFiltersToMetadataResolver(metadataProvider, metadataFilterList);
        }
    }

    protected void addMetadataFiltersToMetadataResolver(AbstractMetadataResolver metadataProvider, MetadataFilter ... metadataFilterList) {
        this.addMetadataFiltersToMetadataResolver(metadataProvider, Arrays.stream(metadataFilterList).collect(Collectors.toList()));
    }

    protected void addMetadataFiltersToMetadataResolver(AbstractMetadataResolver metadataProvider, List<MetadataFilter> metadataFilterList) {
        MetadataFilterChain metadataFilterChain = new MetadataFilterChain();
        metadataFilterChain.setFilters(metadataFilterList);
        LOGGER.debug("Metadata filter chain initialized with [{}] filters", (Object)metadataFilterList.size());
        metadataProvider.setMetadataFilter((MetadataFilter)metadataFilterChain);
    }

    private static void buildEntityRoleFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service.getMetadataCriteriaRoles())) {
            ArrayList roles = new ArrayList();
            Set rolesSet = StringUtils.commaDelimitedListToSet((String)service.getMetadataCriteriaRoles());
            rolesSet.forEach(s -> {
                if (s.equalsIgnoreCase(SPSSODescriptor.DEFAULT_ELEMENT_NAME.getLocalPart())) {
                    LOGGER.debug("Added entity role filter [{}]", (Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME);
                    roles.add(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
                }
                if (s.equalsIgnoreCase(IDPSSODescriptor.DEFAULT_ELEMENT_NAME.getLocalPart())) {
                    LOGGER.debug("Added entity role filter [{}]", (Object)IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
                    roles.add(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
                }
            });
            EntityRoleFilter filter = new EntityRoleFilter(roles);
            filter.setRemoveEmptyEntitiesDescriptors(service.isMetadataCriteriaRemoveEmptyEntitiesDescriptors());
            filter.setRemoveRolelessEntityDescriptors(service.isMetadataCriteriaRemoveRolelessEntityDescriptors());
            metadataFilterList.add((MetadataFilter)filter);
            LOGGER.debug("Added entity role filter with roles [{}]", roles);
        }
    }

    private static void buildPredicateFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service.getMetadataCriteriaDirection()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service.getMetadataCriteriaPattern()) && RegexUtils.isValidRegex((String)service.getMetadataCriteriaPattern())) {
            PredicateFilter.Direction dir = PredicateFilter.Direction.valueOf((String)service.getMetadataCriteriaDirection());
            LOGGER.debug("Metadata predicate filter configuring with direction [{}] and pattern [{}]", (Object)service.getMetadataCriteriaDirection(), (Object)service.getMetadataCriteriaPattern());
            PredicateFilter filter = new PredicateFilter(dir, entityDescriptor -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entityDescriptor.getEntityID()) && entityDescriptor.getEntityID().matches(service.getMetadataCriteriaPattern()));
            metadataFilterList.add((MetadataFilter)filter);
            LOGGER.debug("Added metadata predicate filter with direction [{}] and pattern [{}]", (Object)service.getMetadataCriteriaDirection(), (Object)service.getMetadataCriteriaPattern());
        }
    }

    protected void buildSignatureValidationFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList) throws Exception {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)service.getMetadataSignatureLocation())) {
            LOGGER.warn("No metadata signature location is defined for [{}], so SignatureValidationFilter will not be invoked", (Object)service.getMetadataLocation());
            return;
        }
        this.buildSignatureValidationFilterIfNeeded(service, metadataFilterList, service.getMetadataSignatureLocation());
    }

    protected void buildSignatureValidationFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList, String metadataSignatureResource) throws Exception {
        SignatureValidationFilter signatureValidationFilter = SamlUtils.buildSignatureValidationFilter((String)metadataSignatureResource);
        this.addSignatureValidationFilterIfNeeded(service, signatureValidationFilter, metadataFilterList);
    }

    protected void buildSignatureValidationFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList, Resource metadataSignatureResource) throws Exception {
        SignatureValidationFilter signatureValidationFilter = SamlUtils.buildSignatureValidationFilter((Resource)metadataSignatureResource);
        this.addSignatureValidationFilterIfNeeded(service, signatureValidationFilter, metadataFilterList);
    }

    private void addSignatureValidationFilterIfNeeded(SamlRegisteredService service, SignatureValidationFilter signatureValidationFilter, List<MetadataFilter> metadataFilterList) {
        if (signatureValidationFilter != null) {
            signatureValidationFilter.setRequireSignedRoot(false);
            metadataFilterList.add((MetadataFilter)signatureValidationFilter);
            LOGGER.debug("Added metadata SignatureValidationFilter [{}] for [{}]", (Object)signatureValidationFilter, (Object)service.getServiceId());
        } else {
            LOGGER.warn("Skipped metadata SignatureValidationFilter since signature cannot be located for [{}]", (Object)service.getServiceId());
        }
    }

    protected void buildRequiredValidUntilFilterIfNeeded(SamlRegisteredService service, List<MetadataFilter> metadataFilterList) {
        if (service.getMetadataMaxValidity() > 0L) {
            RequiredValidUntilFilter requiredValidUntilFilter = new RequiredValidUntilFilter(service.getMetadataMaxValidity());
            metadataFilterList.add((MetadataFilter)requiredValidUntilFilter);
            LOGGER.debug("Added metadata RequiredValidUntilFilter with max validity of [{}]", (Object)service.getMetadataMaxValidity());
        } else {
            LOGGER.debug("No metadata maximum validity criteria is defined for [{}], so RequiredValidUntilFilter will not be invoked", (Object)service.getMetadataLocation());
        }
    }

    @Generated
    public BaseSamlRegisteredServiceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        this.samlIdPProperties = samlIdPProperties;
        this.configBean = configBean;
    }
}

