/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class GroovyResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyResourceMetadataResolver.class);

    public GroovyResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    @Override
    public Collection<MetadataResolver> resolve(SamlRegisteredService service) {
        try {
            String metadataLocation = service.getMetadataLocation();
            LOGGER.info("Loading SAML metadata via [{}]", (Object)metadataLocation);
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            Object[] args = new Object[]{service, this.configBean, this.samlIdPProperties, LOGGER};
            MetadataResolver metadataResolver = (MetadataResolver)ScriptingUtils.executeGroovyScript((Resource)metadataResource, (Object[])args, MetadataResolver.class);
            if (metadataResolver != null) {
                return CollectionUtils.wrap((Object)metadataResolver);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<MetadataResolver>(0);
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        String metadataLocation = service.getMetadataLocation();
        return ScriptingUtils.isExternalGroovyScript((String)metadataLocation);
    }
}

