/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.util.DigestUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceCacheKey
implements Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceCacheKey.class);
    static final String KEY_SEPARATOR = "|";
    private static final long serialVersionUID = -7238573226470492601L;
    private final String id;
    private final SamlRegisteredService registeredService;
    private final transient CriteriaSet criteriaSet;
    private final String cacheKey;

    public SamlRegisteredServiceCacheKey(SamlRegisteredService registeredService, CriteriaSet criteriaSet) {
        this.cacheKey = SamlRegisteredServiceCacheKey.getCacheKeyForRegisteredService(registeredService, criteriaSet);
        LOGGER.trace("Calculated service cache key [{}]", (Object)this.cacheKey);
        this.id = SamlRegisteredServiceCacheKey.buildRegisteredServiceCacheKey(this.cacheKey);
        this.registeredService = registeredService;
        this.criteriaSet = criteriaSet;
    }

    private static String buildRegisteredServiceCacheKey(String key) {
        String hashedKey = DigestUtils.sha512((String)key);
        LOGGER.trace("Hashed service cache key [{}] as [{}]", (Object)key, (Object)hashedKey);
        return hashedKey;
    }

    private static String getCacheKeyForRegisteredService(SamlRegisteredService service, CriteriaSet criteriaSet) {
        String entityId;
        String string = entityId = criteriaSet.contains(EntityIdCriterion.class) ? Objects.requireNonNull((EntityIdCriterion)criteriaSet.get(EntityIdCriterion.class)).getEntityId() : service.getServiceId();
        if (SamlUtils.isDynamicMetadataQueryConfigured((String)service.getMetadataLocation())) {
            return entityId;
        }
        return String.format("%s%s%s", entityId, KEY_SEPARATOR, service.getMetadataLocation());
    }

    @Generated
    public String toString() {
        return "SamlRegisteredServiceCacheKey(id=" + this.id + ", registeredService=" + this.registeredService + ", criteriaSet=" + this.criteriaSet + ", cacheKey=" + this.cacheKey + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SamlRegisteredServiceCacheKey)) {
            return false;
        }
        SamlRegisteredServiceCacheKey other = (SamlRegisteredServiceCacheKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SamlRegisteredServiceCacheKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public SamlRegisteredService getRegisteredService() {
        return this.registeredService;
    }

    @Generated
    public CriteriaSet getCriteriaSet() {
        return this.criteriaSet;
    }

    @Generated
    String getCacheKey() {
        return this.cacheKey;
    }
}

