/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataExpirationPolicy;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceMetadataResolverCacheLoader;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.criterion.SatisfyAnyCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceDefaultCachingMetadataResolver
implements SamlRegisteredServiceCachingMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceDefaultCachingMetadataResolver.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final int MAX_CACHE_SIZE = 10000;
    private final SamlRegisteredServiceMetadataResolverCacheLoader chainingMetadataResolverCacheLoader;
    private final LoadingCache<SamlRegisteredServiceCacheKey, MetadataResolver> cache;
    private final OpenSamlConfigBean openSamlConfigBean;

    public SamlRegisteredServiceDefaultCachingMetadataResolver(Duration metadataCacheExpiration, SamlRegisteredServiceMetadataResolverCacheLoader loader, OpenSamlConfigBean openSamlConfigBean) {
        this.openSamlConfigBean = openSamlConfigBean;
        this.chainingMetadataResolverCacheLoader = loader;
        this.cache = Caffeine.newBuilder().maximumSize(10000L).recordStats().expireAfter((Expiry)new SamlRegisteredServiceMetadataExpirationPolicy(metadataCacheExpiration)).build((CacheLoader)this.chainingMetadataResolverCacheLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataResolver resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        Object object = this.$lock;
        synchronized (object) {
            LOGGER.debug("Resolving metadata for [{}] at [{}]", (Object)service.getName(), (Object)service.getMetadataLocation());
            SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
            LOGGER.trace("Locating cached metadata resolver using key [{}] for service [{}]", (Object)cacheKey.getId(), (Object)service.getName());
            return (MetadataResolver)FunctionUtils.doAndRetry(retryContext -> {
                MetadataResolver resolver = this.locateAndCacheMetadataResolver(service, cacheKey);
                if (!this.isMetadataResolverAcceptable(resolver, criteriaSet)) {
                    this.invalidate(service, criteriaSet);
                    LOGGER.warn("SAML metadata resolver [{}] obtained from the cache is unable to produce/resolve valid metadata for [{}]. Metadata resolver cache entry with key [{}] has been invalidated. Retry attempt: [{}]", new Object[]{resolver.getId(), service.getMetadataLocation(), cacheKey.getId(), retryContext.getRetryCount()});
                    throw new SamlException("Unable to locate a valid SAML metadata resolver for " + service.getMetadataLocation() + " to locate " + criteriaSet);
                }
                return resolver;
            });
        }
    }

    protected boolean isMetadataResolverAcceptable(MetadataResolver metadataResolver, CriteriaSet criteriaSet) {
        if (criteriaSet.contains(SatisfyAnyCriterion.class)) {
            return true;
        }
        EntityDescriptor md = (EntityDescriptor)metadataResolver.resolveSingle((Object)criteriaSet);
        return md != null && md.isValid();
    }

    protected MetadataResolver locateAndCacheMetadataResolver(SamlRegisteredService service, SamlRegisteredServiceCacheKey cacheKey) {
        MetadataResolver resolver = Objects.requireNonNull((MetadataResolver)this.cache.get((Object)cacheKey));
        LOGGER.debug("Loaded and cached SAML metadata [{}] from [{}]", (Object)resolver.getId(), (Object)service.getMetadataLocation());
        return resolver;
    }

    Optional<MetadataResolver> resolveIfPresent(SamlRegisteredService service, CriteriaSet criteriaSet) {
        SamlRegisteredServiceCacheKey cacheKey = new SamlRegisteredServiceCacheKey(service, criteriaSet);
        return Optional.ofNullable((MetadataResolver)this.cache.getIfPresent((Object)cacheKey));
    }

    public void invalidate() {
        LOGGER.trace("Invalidating cache, removing all metadata resolvers");
        this.cache.invalidateAll();
    }

    public void invalidate(SamlRegisteredService service, CriteriaSet criteriaSet) {
        LOGGER.trace("Invalidating cache for [{}].", (Object)service.getName());
        SamlRegisteredServiceCacheKey k = new SamlRegisteredServiceCacheKey(service, criteriaSet);
        this.cache.invalidate((Object)k);
    }

    CacheStats getCacheStatistics() {
        return this.cache.stats();
    }

    @Generated
    public OpenSamlConfigBean getOpenSamlConfigBean() {
        return this.openSamlConfigBean;
    }
}

