/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.opensaml.core.xml.persist.FilesystemLoadSaveManager;
import org.opensaml.core.xml.persist.XMLObjectLoadSaveManager;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.LocalDynamicMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FileSystemResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemResourceMetadataResolver.class);

    public FileSystemResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    @Override
    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        try {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            LOGGER.info("Loading SAML metadata from [{}]", (Object)metadataLocation);
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            File metadataFile = metadataResource.getFile();
            AbstractMetadataResolver metadataResolver = this.getMetadataResolver(metadataResource, metadataFile);
            this.configureAndInitializeSingleMetadataResolver(metadataResolver, service);
            return CollectionUtils.wrap((Object)metadataResolver);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new ArrayList(0);
        }
    }

    private AbstractMetadataResolver getMetadataResolver(AbstractResource metadataResource, File metadataFile) {
        if (metadataFile.isDirectory()) {
            return new LocalDynamicMetadataResolver((XMLObjectLoadSaveManager)new FilesystemLoadSaveManager(metadataFile, this.configBean.getParserPool()));
        }
        return new InMemoryResourceMetadataResolver((Resource)metadataResource, this.configBean);
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        try {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            return metadataResource instanceof FileSystemResource;
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isAvailable(SamlRegisteredService service) {
        return this.supports(service);
    }
}

