/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.inspektr.audit.annotation.Audit;
import org.opensaml.core.xml.persist.FilesystemLoadSaveManager;
import org.opensaml.core.xml.persist.XMLObjectLoadSaveManager;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DefaultLocalDynamicSourceKeyGenerator;
import org.opensaml.saml.metadata.resolver.impl.LocalDynamicMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FileSystemResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemResourceMetadataResolver.class);

    public FileSystemResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    @Override
    @Audit(action="SAML2_METADATA_RESOLUTION", actionResolverName="SAML2_METADATA_RESOLUTION_ACTION_RESOLVER", resourceResolverName="SAML2_METADATA_RESOLUTION_RESOURCE_RESOLVER")
    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        return (Collection)FunctionUtils.doAndHandle(() -> {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            LOGGER.info("Loading SAML metadata from [{}]", (Object)metadataLocation);
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            File metadataFile = metadataResource.getFile();
            AbstractMetadataResolver metadataResolver = this.getMetadataResolver(metadataResource, metadataFile);
            this.configureAndInitializeSingleMetadataResolver(metadataResolver, service);
            return CollectionUtils.wrap((Object)metadataResolver);
        }, throwable -> new ArrayList(0)).get();
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            AbstractResource metadataResource = ResourceUtils.isUrl((String)metadataLocation) ? null : ResourceUtils.getResourceFrom((String)metadataLocation);
            return metadataResource instanceof FileSystemResource && !ScriptingUtils.isGroovyScript((String)metadataLocation);
        }, throwable -> false).get();
    }

    @Override
    public boolean isAvailable(SamlRegisteredService service) {
        return this.supports(service);
    }

    private AbstractMetadataResolver getMetadataResolver(AbstractResource metadataResource, File metadataFile) throws Exception {
        if (metadataFile.isDirectory()) {
            DefaultLocalDynamicSourceKeyGenerator sourceStrategy = new DefaultLocalDynamicSourceKeyGenerator("", ".xml", "");
            FilesystemLoadSaveManager manager = new FilesystemLoadSaveManager(metadataFile, this.configBean.getParserPool());
            return new LocalDynamicMetadataResolver((XMLObjectLoadSaveManager)manager, (Function)sourceStrategy);
        }
        return new InMemoryResourceMetadataResolver((Resource)metadataResource, this.configBean);
    }
}

