/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.idp.metadata.BaseElementMetadataResolver;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPSamlRegisteredServiceCriterion;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.w3c.dom.Element;

public class SamlIdPMetadataResolver
extends BaseElementMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataResolver.class);
    private final SamlIdPMetadataLocator locator;
    private final SamlIdPMetadataGenerator generator;
    private final OpenSamlConfigBean openSamlConfigBean;
    private final CasConfigurationProperties casProperties;
    private final Cache<String, Iterable<EntityDescriptor>> metadataCache;

    public SamlIdPMetadataResolver(SamlIdPMetadataLocator locator, SamlIdPMetadataGenerator generator, OpenSamlConfigBean openSamlConfigBean, CasConfigurationProperties casProperties) {
        this.locator = locator;
        this.generator = generator;
        this.openSamlConfigBean = openSamlConfigBean;
        this.casProperties = casProperties;
        this.setResolveViaPredicatesOnly(true);
        SamlIdPProperties idp = casProperties.getAuthn().getSamlIdp();
        this.metadataCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(Beans.newDuration((String)idp.getMetadata().getCore().getCacheExpiration())).build();
    }

    private static List<Optional<SamlRegisteredService>> determineFilteringCriteria(CriteriaSet criteria) {
        ArrayList<Optional<SamlRegisteredService>> results = new ArrayList<Optional<SamlRegisteredService>>();
        if (criteria.contains(SamlIdPSamlRegisteredServiceCriterion.class)) {
            SamlIdPSamlRegisteredServiceCriterion criterion = (SamlIdPSamlRegisteredServiceCriterion)criteria.get(SamlIdPSamlRegisteredServiceCriterion.class);
            results.add(Optional.of(Objects.requireNonNull(criterion).registeredService()));
        }
        results.add(Optional.empty());
        return results;
    }

    @Nonnull
    @Retryable(retryFor={ResolverException.class}, maxAttempts=3, backoff=@Backoff(delay=1000L, maxDelay=5000L))
    public Iterable<EntityDescriptor> resolve(CriteriaSet criteria) {
        List<Optional<SamlRegisteredService>> filteringCriteria = SamlIdPMetadataResolver.determineFilteringCriteria(criteria);
        for (Optional<SamlRegisteredService> filter : filteringCriteria) {
            String cacheKey = this.getMetadataCacheKey(filter, criteria);
            LOGGER.debug("Cache key for SAML IdP metadata is [{}]", (Object)cacheKey);
            Iterable entities = (Iterable)this.metadataCache.getIfPresent((Object)cacheKey);
            if (entities != null) {
                return entities;
            }
            entities = (Iterable)FunctionUtils.doUnchecked(() -> this.resolveMetadata(criteria, filter));
            if (entities == null || Iterables.size((Iterable)entities) <= 0) continue;
            this.metadataCache.put((Object)cacheKey, (Object)entities);
            return entities;
        }
        return new ArrayList<EntityDescriptor>(0);
    }

    private String getMetadataCacheKey(Optional<SamlRegisteredService> serviceResult, CriteriaSet criteriaSet) {
        return serviceResult.map(registeredService -> registeredService.getName() + registeredService.getId()).or(() -> criteriaSet.contains(EntityIdCriterion.class) ? Optional.of(((EntityIdCriterion)criteriaSet.get(EntityIdCriterion.class)).getEntityId()) : Optional.empty()).orElseGet(() -> this.casProperties.getAuthn().getSamlIdp().getCore().getEntityId());
    }

    private Iterable<EntityDescriptor> resolveMetadata(CriteriaSet criteria, Optional<SamlRegisteredService> registeredService) throws Throwable {
        if (!this.locator.exists(registeredService) && this.locator.shouldGenerateMetadataFor(registeredService)) {
            this.generator.generate(registeredService);
        }
        Resource resource = this.locator.resolveMetadata(registeredService);
        LOGGER.trace("Resolved metadata resource is [{}]", (Object)resource);
        if (resource.contentLength() > 0L) {
            Element element = SamlUtils.getRootElementFrom((InputStream)resource.getInputStream(), (OpenSamlConfigBean)this.openSamlConfigBean);
            LOGGER.trace("Located metadata root element [{}]", (Object)element.getNodeName());
            this.setMetadataRootElement(element);
            LOGGER.trace("Resolving metadata for criteria [{}]", (Object)criteria);
            return super.resolve(criteria);
        }
        return null;
    }
}

