/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.CanWriteFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.inspektr.audit.annotation.Audit;
import org.jooq.lambda.Unchecked;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class UrlResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlResourceMetadataResolver.class);
    private static final String FILENAME_EXTENSION_XML = ".xml";
    private static final String DIRNAME_METADATA_BACKUPS = "metadata-backups";
    private final HttpClient httpClient;
    private final File metadataBackupDirectory;

    public UrlResourceMetadataResolver(HttpClient httpClient, SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
        this.httpClient = httpClient;
        SamlIdPMetadataProperties md = samlIdPProperties.getMetadata();
        String backupLocation = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)md.getHttp().getMetadataBackupLocation(), (CharSequence)md.getFileSystem().getLocation());
        String location = SpringExpressionLanguageValueResolver.getInstance().resolve(backupLocation);
        this.metadataBackupDirectory = (File)FunctionUtils.doUnchecked(() -> new File(ResourceUtils.getRawResourceFrom((String)location).getFile(), DIRNAME_METADATA_BACKUPS));
        FunctionUtils.doAndHandle(file -> {
            LOGGER.trace("Creating metadata backup directory at [{}]", file);
            FileUtils.forceMkdir((File)file);
        }, e -> {
            LOGGER.error("Unable to create metadata backup directory [{}] to store downloaded metadata. This is likely due to a permission issue", (Object)this.metadataBackupDirectory);
            LOGGER.debug(e.getMessage(), e);
            return this.metadataBackupDirectory;
        }).accept(this.metadataBackupDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Audit(action="SAML2_METADATA_RESOLUTION", actionResolverName="SAML2_METADATA_RESOLUTION_ACTION_RESOLVER", resourceResolverName="SAML2_METADATA_RESOLUTION_RESOURCE_RESOLVER")
    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        HttpResponse response = null;
        try {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)service);
            Set<String> metadataLocations = this.getMetadataLocationsForService(service, criteriaSet);
            for (String metadataLocation : metadataLocations) {
                HttpStatus status;
                LOGGER.info("Loading SAML metadata from [{}]", metadataLocations);
                UrlResource metadataResource = new UrlResource(metadataLocation);
                File backupFile = this.getMetadataBackupFile((AbstractResource)metadataResource, service);
                if (backupFile.exists() && this.samlIdPProperties.getMetadata().getHttp().isForceMetadataRefresh()) {
                    LOGGER.debug("CAS is configured to forcefully refresh metadata for service [{}]. Old metadata backup files will now be deleted for this service.", (Object)service.getName());
                    this.cleanUpExpiredBackupMetadataFilesFor((AbstractResource)metadataResource, service);
                }
                String canonicalPath = backupFile.getCanonicalPath();
                LOGGER.debug("Metadata backup file for [{}] will be at [{}]", (Object)service.getName(), (Object)canonicalPath);
                FileUtils.forceMkdirParent((File)backupFile);
                if (backupFile.exists() && backupFile.canRead()) {
                    block13: {
                        List list;
                        try {
                            InMemoryResourceMetadataResolver metadataProvider = this.getMetadataResolverFromFile(backupFile);
                            this.configureAndInitializeSingleMetadataResolver((AbstractMetadataResolver)metadataProvider, service);
                            if (!Boolean.TRUE.equals(metadataProvider.isRootValid())) break block13;
                            LOGGER.debug("Metadata backup file for service [{}] at [{}] is valid. CAS will reuse the SAML2 metadata file at [{}] and will not download new metadata from [{}]", new Object[]{service.getName(), canonicalPath, canonicalPath, metadataLocation});
                            list = CollectionUtils.wrap((Object)metadataProvider);
                        }
                        catch (Exception e) {
                            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                            break block13;
                        }
                        HttpUtils.close((HttpResponse)response);
                        return list;
                    }
                    LOGGER.info("Metadata backup file found for service [{}] at [{}] is invalid and will be disregarded. CAS will proceed to download new metadata from [{}]", new Object[]{service.getName(), canonicalPath, metadataLocation});
                    FileUtils.forceDelete((File)backupFile);
                }
                if (!this.shouldHttpResponseStatusBeProcessed(status = HttpStatus.valueOf((int)(response = this.fetchMetadata(service, metadataLocation, criteriaSet, backupFile)).getCode()))) continue;
                AbstractMetadataResolver metadataProvider = this.getMetadataResolverFromResponse(response, backupFile);
                this.configureAndInitializeSingleMetadataResolver(metadataProvider, service);
                List list = CollectionUtils.wrap((Object)metadataProvider);
                HttpUtils.close((HttpResponse)response);
                return list;
            }
            HttpUtils.close(response);
            return new ArrayList();
        }
        catch (UnauthorizedServiceException e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new SamlException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new ArrayList();
        }
        finally {
            HttpUtils.close(response);
        }
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        try {
            Set<String> metadataLocations = this.getMetadataLocationsForService(service, new CriteriaSet());
            return metadataLocations.stream().anyMatch(metadataLocation -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)metadataLocation) && org.apache.commons.lang3.StringUtils.startsWith((CharSequence)metadataLocation, (CharSequence)"http") && !SamlUtils.isDynamicMetadataQueryConfigured((String)metadataLocation));
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isAvailable(SamlRegisteredService service) {
        if (this.supports(service)) {
            Set locations = StringUtils.commaDelimitedListToSet((String)SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation()));
            return locations.stream().map(metadataLocation -> org.apache.commons.lang3.StringUtils.substringBefore((String)metadataLocation, (String)"/entities/{0}")).anyMatch(metadataLocation -> {
                HttpStatus status = HttpRequestUtils.pingUrl((String)metadataLocation);
                return !status.isError();
            });
        }
        return false;
    }

    protected boolean shouldHttpResponseStatusBeProcessed(HttpStatus status) {
        return status.is2xxSuccessful();
    }

    protected AbstractMetadataResolver getMetadataResolverFromResponse(HttpResponse response, File backupFile) throws Exception {
        HttpEntity entity = ((HttpEntityContainer)response).getEntity();
        String result = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
        Path path = backupFile.toPath();
        LOGGER.trace("Writing metadata to file at [{}]", (Object)path);
        try (BufferedWriter output = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            IOUtils.write((String)result, (Writer)output);
            output.flush();
        }
        EntityUtils.consume((HttpEntity)entity);
        return this.getMetadataResolverFromFile(backupFile);
    }

    private InMemoryResourceMetadataResolver getMetadataResolverFromFile(File backupFile) throws Exception {
        InMemoryResourceMetadataResolver metadataResolver = new InMemoryResourceMetadataResolver(backupFile, this.configBean);
        metadataResolver.setId("RegisteredServiceMetadata-" + backupFile.getName());
        return metadataResolver;
    }

    protected HttpResponse fetchMetadata(SamlRegisteredService service, String metadataLocation, CriteriaSet criteriaSet, File backupFile) {
        LOGGER.debug("Fetching metadata from [{}]", (Object)metadataLocation);
        HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.GET).url(metadataLocation).proxyUrl(service.getMetadataProxyLocation()).httpClient(this.httpClient).maximumRetryAttempts(this.samlIdPProperties.getMetadata().getCore().getMaximumRetryAttempts()).build();
        return HttpUtils.execute((HttpExecutionRequest)exec);
    }

    protected Set<String> getMetadataLocationsForService(SamlRegisteredService service, CriteriaSet criteriaSet) {
        return StringUtils.commaDelimitedListToSet((String)SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation()));
    }

    protected File getMetadataBackupFile(AbstractResource metadataResource, SamlRegisteredService service) throws IOException {
        LOGGER.debug("Metadata backup directory is at [{}]", (Object)this.metadataBackupDirectory.getCanonicalPath());
        String metadataFileName = this.getBackupMetadataFilenamePrefix(metadataResource, service).concat(FILENAME_EXTENSION_XML);
        File backupFile = new File(this.metadataBackupDirectory, metadataFileName);
        if (backupFile.exists()) {
            LOGGER.info("Metadata file designated for service [{}] already exists at path [{}].", (Object)service.getName(), (Object)backupFile.getCanonicalPath());
        } else {
            LOGGER.debug("Metadata to fetch for service [{}] will be placed at [{}]", (Object)service.getName(), (Object)backupFile.getCanonicalPath());
        }
        return backupFile;
    }

    protected String getBackupMetadataFilenamePrefix(AbstractResource metadataResource, SamlRegisteredService service) {
        String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
        String fileName = SamlUtils.isDynamicMetadataQueryConfigured((String)metadataLocation) ? service.getServiceId() : metadataLocation;
        String sha = DigestUtils.sha((String)fileName);
        LOGGER.trace("Metadata backup file for metadata location [{}] is linked to [{}]", (Object)fileName, (Object)sha);
        return sha;
    }

    private void cleanUpExpiredBackupMetadataFilesFor(AbstractResource metadataResource, SamlRegisteredService service) {
        String prefix = this.getBackupMetadataFilenamePrefix(metadataResource, service);
        Collection backups = FileUtils.listFiles((File)this.metadataBackupDirectory, (IOFileFilter)new AndFileFilter(CollectionUtils.wrapList((Object[])new IOFileFilter[]{new PrefixFileFilter(prefix, IOCase.INSENSITIVE), new SuffixFileFilter(FILENAME_EXTENSION_XML, IOCase.INSENSITIVE), CanWriteFileFilter.CAN_WRITE, CanReadFileFilter.CAN_READ})), (IOFileFilter)TrueFileFilter.INSTANCE);
        backups.forEach(Unchecked.consumer(FileUtils::forceDelete));
    }
}

