/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache;

import com.github.benmanes.caffeine.cache.Expiry;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.CachedMetadataResolverResult;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCacheKey;
import org.apereo.cas.util.DateTimeUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record SamlRegisteredServiceMetadataExpirationPolicy(Duration defaultExpiration) implements Expiry<SamlRegisteredServiceCacheKey, CachedMetadataResolverResult>
{
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceMetadataExpirationPolicy.class);

    public long expireAfterCreate(@NonNull SamlRegisteredServiceCacheKey cacheKey, @NonNull CachedMetadataResolverResult cacheResult, long currentTime) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        if (cacheResult == null) {
            throw new NullPointerException("cacheResult is marked non-null but is null");
        }
        SamlRegisteredService service = cacheKey.getRegisteredService();
        long duration = this.getCacheDurationForServiceProvider(service, cacheResult);
        if (duration >= 0L) {
            LOGGER.trace("Metadata cache duration for [{}] is [{}]", (Object)service.getName(), (Object)duration);
            return duration;
        }
        LOGGER.trace("Metadata for [{}] does not define caching policies", (Object)service.getName());
        if (StringUtils.isNotBlank((CharSequence)service.getMetadataExpirationDuration())) {
            LOGGER.debug("Service [{}] defines a cache expiration duration of [{}]", (Object)service.getName(), (Object)service.getMetadataExpirationDuration());
            return Beans.newDuration((String)service.getMetadataExpirationDuration()).toNanos();
        }
        RegisteredServiceExpirationPolicy expPolicy = service.getExpirationPolicy();
        if (expPolicy != null && StringUtils.isNotBlank((CharSequence)expPolicy.getExpirationDate())) {
            LocalDateTime expDate = DateTimeUtils.localDateTimeOf((String)expPolicy.getExpirationDate());
            LocalDateTime now = LocalDateTime.now(Clock.systemDefaultZone());
            long result = Duration.between(now, expDate).toNanos();
            LOGGER.trace("Using the difference between now [{}] and expiration date [{}] from the service expiration policy: [{}]", new Object[]{now, expDate, result});
            return result;
        }
        LOGGER.trace("Service [{}] does not define caching policies. Falling back onto default...", (Object)service.getName());
        return this.defaultExpiration.toNanos();
    }

    public long expireAfterUpdate(@NonNull SamlRegisteredServiceCacheKey cacheKey, @NonNull CachedMetadataResolverResult cacheResult, long currentTime, long currentDuration) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        if (cacheResult == null) {
            throw new NullPointerException("cacheResult is marked non-null but is null");
        }
        LOGGER.trace("Cache expiration duration after updates is set to [{}] nanoseconds", (Object)currentDuration);
        return currentDuration;
    }

    public long expireAfterRead(@NonNull SamlRegisteredServiceCacheKey cacheKey, @NonNull CachedMetadataResolverResult cacheResult, long currentTime, long currentDuration) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        if (cacheResult == null) {
            throw new NullPointerException("cacheResult is marked non-null but is null");
        }
        LOGGER.trace("Cache expiration duration after reads is set to [{}] nanoseconds", (Object)currentDuration);
        return currentDuration;
    }

    long getCacheDurationForServiceProvider(SamlRegisteredService service, CachedMetadataResolverResult cacheResult) {
        try {
            if (StringUtils.isBlank((CharSequence)service.getServiceId())) {
                LOGGER.warn("Unable to determine duration for SAML service [{}] with no entity id", (Object)service.getName());
                return -1L;
            }
            CriteriaSet set = new CriteriaSet();
            set.add((Object)new EntityIdCriterion(service.getServiceId()));
            set.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
            EntityDescriptor entitySp = (EntityDescriptor)cacheResult.getMetadataResolver().resolveSingle((Object)set);
            if (entitySp != null && entitySp.getCacheDuration() != null) {
                LOGGER.debug("Located cache duration [{}] specified in SP metadata for [{}]", (Object)entitySp.getCacheDuration(), (Object)entitySp.getEntityID());
                return TimeUnit.MILLISECONDS.toNanos(entitySp.getCacheDuration().toMillis());
            }
            set.clear();
            set.add((Object)new EntityIdCriterion(service.getServiceId()));
            EntityDescriptor entity = (EntityDescriptor)cacheResult.getMetadataResolver().resolveSingle((Object)set);
            if (entity != null && entity.getCacheDuration() != null) {
                LOGGER.debug("Located cache duration [{}] specified in entity metadata for [{}]", (Object)entity.getCacheDuration(), (Object)entity.getEntityID());
                return TimeUnit.MILLISECONDS.toNanos(entity.getCacheDuration().toMillis());
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return -1L;
    }
}

