/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="SAML2_ATTRIBUTE_QUERY_TICKETS")
@DiscriminatorColumn(name="TYPE")
@DiscriminatorValue(value="SATQ")
public class SamlAttributeQueryTicketImpl
extends AbstractTicket
implements SamlAttributeQueryTicket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlAttributeQueryTicketImpl.class);
    private static final long serialVersionUID = 6276140828446447398L;
    @Column
    private String relyingParty;
    @Column(length=5000)
    private String object;
    @ManyToOne(targetEntity=TicketGrantingTicketImpl.class)
    @JsonProperty(value="ticketGrantingTicket")
    private TicketGrantingTicket ticketGrantingTicket;
    @Lob
    @Column(name="SERVICE", nullable=false)
    private Service service;

    public SamlAttributeQueryTicketImpl(String id, Service service, ExpirationPolicy expirationPolicy, String relyingParty, String samlObject, TicketGrantingTicket ticketGrantingTicket) {
        super(id, expirationPolicy);
        this.service = service;
        this.relyingParty = relyingParty;
        this.object = samlObject;
        this.ticketGrantingTicket = ticketGrantingTicket;
    }

    public boolean isFromNewLogin() {
        return true;
    }

    public boolean isValidFor(Service serviceToValidate) {
        this.update();
        return serviceToValidate.matches(this.service);
    }

    public ProxyGrantingTicket grantProxyGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        throw new UnsupportedOperationException("No PGT grant is available");
    }

    public Authentication getAuthentication() {
        return this.ticketGrantingTicket.getAuthentication();
    }

    public String getPrefix() {
        return "SATQ";
    }

    @Override
    @Generated
    public String getRelyingParty() {
        return this.relyingParty;
    }

    @Override
    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public TicketGrantingTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public SamlAttributeQueryTicketImpl() {
    }

    @Generated
    public void setRelyingParty(String relyingParty) {
        this.relyingParty = relyingParty;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setTicketGrantingTicket(TicketGrantingTicket ticketGrantingTicket) {
        this.ticketGrantingTicket = ticketGrantingTicket;
    }

    @Generated
    public void setService(Service service) {
        this.service = service;
    }
}

