/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.artifact;

import java.io.StringWriter;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketImpl;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSamlArtifactTicketFactory
implements SamlArtifactTicketFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSamlArtifactTicketFactory.class);
    protected final ExpirationPolicy expirationPolicy;
    protected final OpenSamlConfigBean configBean;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SamlArtifactTicket create(String artifactId, Authentication authentication, TicketGrantingTicket ticketGrantingTicket, String issuer, String relyingParty, SAMLObject samlObject) {
        try (StringWriter w = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlObject);){
            String codeId = this.createTicketIdFor(artifactId);
            Service service = this.webApplicationServiceFactory.createService(relyingParty);
            SamlArtifactTicketImpl at = new SamlArtifactTicketImpl(codeId, service, authentication, this.expirationPolicy, ticketGrantingTicket, issuer, relyingParty, w.toString());
            if (ticketGrantingTicket != null) {
                ticketGrantingTicket.getDescendantTickets().add(at.getId());
            }
            SamlArtifactTicketImpl samlArtifactTicketImpl = at;
            return samlArtifactTicketImpl;
        }
    }

    public TicketFactory get(Class<? extends Ticket> clazz) {
        return this;
    }

    @Generated
    public DefaultSamlArtifactTicketFactory(ExpirationPolicy expirationPolicy, OpenSamlConfigBean configBean, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        this.expirationPolicy = expirationPolicy;
        this.configBean = configBean;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }
}

