/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.artifact;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="SAML2_ARTIFACTS")
@DiscriminatorColumn(name="TYPE")
@DiscriminatorValue(value="SART")
public class SamlArtifactTicketImpl
extends AbstractTicket
implements SamlArtifactTicket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlArtifactTicketImpl.class);
    private static final long serialVersionUID = 6276140828446447398L;
    @Column(length=5000)
    private String issuer;
    @Column(length=5000)
    private String relyingPartyId;
    @Column(length=10000)
    private String object;
    @ManyToOne(targetEntity=TicketGrantingTicketImpl.class)
    @JsonProperty(value="ticketGrantingTicket")
    private TicketGrantingTicket ticketGrantingTicket;
    @Lob
    @Column(name="SERVICE", nullable=false)
    private Service service;
    @Lob
    @Column(name="AUTHENTICATION", nullable=false, length=0x7FFFFFFF)
    private Authentication authentication;

    public SamlArtifactTicketImpl(String id, Service service, Authentication authentication, ExpirationPolicy expirationPolicy, TicketGrantingTicket ticketGrantingTicket, String issuer, String relyingParty, String samlObject) {
        super(id, expirationPolicy);
        this.service = service;
        this.authentication = authentication;
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.relyingPartyId = relyingParty;
        this.issuer = issuer;
        this.object = samlObject;
    }

    public boolean isFromNewLogin() {
        return true;
    }

    public boolean isValidFor(Service serviceToValidate) {
        this.update();
        return serviceToValidate.matches(this.service);
    }

    public ProxyGrantingTicket grantProxyGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        throw new UnsupportedOperationException("No proxy-granting ticket is available");
    }

    public String getPrefix() {
        return "SART";
    }

    @Override
    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @Generated
    public String getRelyingPartyId() {
        return this.relyingPartyId;
    }

    @Override
    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public TicketGrantingTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Generated
    public SamlArtifactTicketImpl() {
    }
}

