/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.artifact;

import java.io.StringWriter;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketImpl;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;

public class DefaultSamlArtifactTicketFactory
implements SamlArtifactTicketFactory {
    protected final ExpirationPolicyBuilder<SamlArtifactTicket> expirationPolicy;
    protected final OpenSamlConfigBean configBean;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    @Override
    public SamlArtifactTicket create(String artifactId, Authentication authentication, TicketGrantingTicket ticketGrantingTicket, String issuer, String relyingParty, SAMLObject samlObject) {
        SamlArtifactTicketImpl samlArtifactTicketImpl;
        block9: {
            StringWriter w = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlObject);
            try {
                String codeId = this.createTicketIdFor(artifactId);
                WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(relyingParty);
                SamlArtifactTicketImpl at = new SamlArtifactTicketImpl(codeId, (Service)service, authentication, this.expirationPolicy.buildTicketExpirationPolicy(), ticketGrantingTicket, issuer, relyingParty, w.toString());
                if (ticketGrantingTicket != null) {
                    ticketGrantingTicket.getDescendantTickets().add(at.getId());
                }
                samlArtifactTicketImpl = at;
                if (w == null) break block9;
            }
            catch (Throwable throwable) {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            w.close();
        }
        return samlArtifactTicketImpl;
    }

    public Class<? extends Ticket> getTicketType() {
        return SamlArtifactTicket.class;
    }

    @Generated
    public DefaultSamlArtifactTicketFactory(ExpirationPolicyBuilder<SamlArtifactTicket> expirationPolicy, OpenSamlConfigBean configBean, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        this.expirationPolicy = expirationPolicy;
        this.configBean = configBean;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }
}

