/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.query;

import java.io.StringWriter;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketImpl;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;

public class DefaultSamlAttributeQueryTicketFactory
implements SamlAttributeQueryTicketFactory {
    protected final ExpirationPolicyBuilder expirationPolicy;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    protected final OpenSamlConfigBean configBean;

    @Override
    public SamlAttributeQueryTicket create(String id, SAMLObject samlObject, String relyingParty, TicketGrantingTicket ticketGrantingTicket) {
        SamlAttributeQueryTicketImpl samlAttributeQueryTicketImpl;
        block9: {
            StringWriter w = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlObject);
            try {
                String codeId = this.createTicketIdFor(id);
                WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(relyingParty);
                SamlAttributeQueryTicketImpl at = new SamlAttributeQueryTicketImpl(codeId, (Service)service, this.expirationPolicy.buildTicketExpirationPolicy(), relyingParty, w.toString(), ticketGrantingTicket);
                if (ticketGrantingTicket != null) {
                    ticketGrantingTicket.getDescendantTickets().add(at.getId());
                }
                samlAttributeQueryTicketImpl = at;
                if (w == null) break block9;
            }
            catch (Throwable throwable) {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            w.close();
        }
        return samlAttributeQueryTicketImpl;
    }

    public Class<? extends Ticket> getTicketType() {
        return SamlAttributeQueryTicket.class;
    }

    @Generated
    public DefaultSamlAttributeQueryTicketFactory(ExpirationPolicyBuilder expirationPolicy, ServiceFactory<WebApplicationService> webApplicationServiceFactory, OpenSamlConfigBean configBean) {
        this.expirationPolicy = expirationPolicy;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.configBean = configBean;
    }
}

