/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller(value="samlIdPMetadataController")
public class SamlIdPMetadataController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataController.class);
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private final SamlIdPMetadataGenerator metadataAndCertificatesGenerationService;
    private final SamlIdPMetadataLocator samlIdPMetadataLocator;

    @PostConstruct
    public void postConstruct() {
        this.metadataAndCertificatesGenerationService.generate();
    }

    @GetMapping(path={"/idp/metadata"})
    public void generateMetadataForIdp(HttpServletResponse response) throws IOException {
        this.metadataAndCertificatesGenerationService.generate();
        InputStream md = this.samlIdPMetadataLocator.getMetadata().getInputStream();
        String contents = IOUtils.toString((InputStream)md, (Charset)StandardCharsets.UTF_8);
        response.setContentType(CONTENT_TYPE);
        response.setStatus(200);
        try (PrintWriter writer = response.getWriter();){
            LOGGER.debug("Producing metadata for the response");
            writer.write(contents);
            writer.flush();
        }
    }

    @Generated
    public SamlIdPMetadataController(SamlIdPMetadataGenerator metadataAndCertificatesGenerationService, SamlIdPMetadataLocator samlIdPMetadataLocator) {
        this.metadataAndCertificatesGenerationService = metadataAndCertificatesGenerationService;
        this.samlIdPMetadataLocator = samlIdPMetadataLocator;
    }
}

