/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectSignatureValidator;
import org.jasig.cas.client.util.CommonUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;

public class IdPInitiatedProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(IdPInitiatedProfileHandlerController.class);

    public IdPInitiatedProfileHandlerController(SamlIdPObjectSigner samlObjectSigner, ParserPool parserPool, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver, OpenSamlConfigBean configBean, SamlProfileObjectBuilder<Response> responseBuilder, CasConfigurationProperties casProperties, SamlObjectSignatureValidator samlObjectSignatureValidator, Service callbackService) {
        super(samlObjectSigner, parserPool, authenticationSystemSupport, servicesManager, webApplicationServiceFactory, samlRegisteredServiceCachingMetadataResolver, configBean, responseBuilder, casProperties, samlObjectSignatureValidator, callbackService);
    }

    @GetMapping(path={"/idp/profile/SAML2/Unsolicited/SSO"})
    protected void handleIdPInitiatedSsoRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        String providerId = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)"providerId");
        if (StringUtils.isBlank((CharSequence)providerId)) {
            LOGGER.warn("No providerId parameter given in unsolicited SSO authentication request.");
            throw new MessageDecodingException("No providerId parameter given in unsolicited SSO authentication request.");
        }
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(providerId);
        Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(registeredService, providerId);
        if (!adaptor.isPresent()) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + providerId);
        }
        String shire = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)"shire");
        SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
        if (StringUtils.isBlank((CharSequence)shire)) {
            LOGGER.warn("Resolving service provider assertion consumer service URL for [{}] and binding [{}]", (Object)providerId, (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            AssertionConsumerService acs = facade.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            shire = acs.getLocation();
        }
        if (StringUtils.isBlank((CharSequence)shire)) {
            LOGGER.warn("Unable to resolve service provider assertion consumer service URL for AuthnRequest construction for entityID: [{}]", (Object)providerId);
            throw new MessageDecodingException("Unable to resolve SP ACS URL for AuthnRequest construction");
        }
        String target = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)"target");
        String time = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)"time");
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.configBean.getBuilderFactory().getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest authnRequest = (AuthnRequest)builder.buildObject();
        authnRequest.setAssertionConsumerServiceURL(shire);
        SAMLObjectBuilder isBuilder = (SAMLObjectBuilder)this.configBean.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)isBuilder.buildObject();
        issuer.setValue(providerId);
        authnRequest.setIssuer(issuer);
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        SAMLObjectBuilder pBuilder = (SAMLObjectBuilder)this.configBean.getBuilderFactory().getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)pBuilder.buildObject();
        nameIDPolicy.setAllowCreate(Boolean.TRUE);
        authnRequest.setNameIDPolicy(nameIDPolicy);
        if (NumberUtils.isCreatable((String)time)) {
            authnRequest.setIssueInstant(new DateTime(TimeUnit.SECONDS.convert(Long.parseLong(time), TimeUnit.MILLISECONDS), (Chronology)ISOChronology.getInstanceUTC()));
        } else {
            authnRequest.setIssueInstant(new DateTime((Object)DateTime.now(), (Chronology)ISOChronology.getInstanceUTC()));
        }
        authnRequest.setForceAuthn(Boolean.FALSE);
        if (StringUtils.isNotBlank((CharSequence)target)) {
            request.setAttribute("RelayState", (Object)target);
        }
        MessageContext ctx = new MessageContext();
        ctx.setAutoCreateSubcontexts(true);
        if (facade.isAuthnRequestsSigned()) {
            this.samlObjectSigner.encode(authnRequest, registeredService, facade, response, request, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (RequestAbstractType)authnRequest);
        }
        ctx.setMessage((Object)authnRequest);
        ((SAMLBindingContext)ctx.getSubcontext(SAMLBindingContext.class, true)).setHasBindingSignature(false);
        SAMLBindingSupport.setRelayState((MessageContext)ctx, (String)target);
        Pair pair = Pair.of((Object)authnRequest, (Object)ctx);
        this.initiateAuthenticationRequest((Pair<? extends SignableSAMLObject, MessageContext>)pair, response, request);
    }
}

