/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.util.EncodingUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.KeyInfoReferenceProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SamlObjectEncrypter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlObjectEncrypter.class);
    protected List overrideDataEncryptionAlgorithms;
    protected List overrideKeyEncryptionAlgorithms;
    protected List overrideBlackListedEncryptionAlgorithms;
    protected List overrideWhiteListedAlgorithms;
    @Autowired
    private CasConfigurationProperties casProperties;

    public SamlObjectEncrypter(List overrideDataEncryptionAlgorithms, List overrideKeyEncryptionAlgorithms, List overrideBlackListedEncryptionAlgorithms, List overrideWhiteListedAlgorithms) {
        this.overrideDataEncryptionAlgorithms = overrideDataEncryptionAlgorithms;
        this.overrideKeyEncryptionAlgorithms = overrideKeyEncryptionAlgorithms;
        this.overrideBlackListedEncryptionAlgorithms = overrideBlackListedEncryptionAlgorithms;
        this.overrideWhiteListedAlgorithms = overrideWhiteListedAlgorithms;
    }

    public EncryptedAssertion encode(Assertion samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletResponse response, HttpServletRequest request) throws SamlException {
        String className = samlObject.getClass().getName();
        String entityId = adaptor.getEntityId();
        LOGGER.debug("Attempting to encrypt [{}] for [{}]", (Object)className, (Object)entityId);
        Credential credential = this.getKeyEncryptionCredential(entityId, adaptor, service);
        LOGGER.info("Found encryption public key: [{}]", (Object)EncodingUtils.encodeBase64((byte[])credential.getPublicKey().getEncoded()));
        KeyEncryptionParameters keyEncParams = this.getKeyEncryptionParameters(samlObject, service, adaptor, credential);
        LOGGER.debug("Key encryption algorithm for [{}] is [{}]", (Object)keyEncParams.getRecipient(), (Object)keyEncParams.getAlgorithm());
        DataEncryptionParameters dataEncParams = this.getDataEncryptionParameters(samlObject, service, adaptor);
        LOGGER.debug("Data encryption algorithm for [{}] is [{}]", (Object)entityId, (Object)dataEncParams.getAlgorithm());
        Encrypter encrypter = this.getEncrypter(samlObject, service, adaptor, keyEncParams, dataEncParams);
        LOGGER.debug("Attempting to encrypt [{}] for [{}] with key placement of [{}]", new Object[]{className, entityId, encrypter.getKeyPlacement()});
        return encrypter.encrypt(samlObject);
    }

    protected Encrypter getEncrypter(Assertion samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, KeyEncryptionParameters keyEncParams, DataEncryptionParameters dataEncParams) {
        Encrypter encrypter = new Encrypter(dataEncParams, keyEncParams);
        encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
        return encrypter;
    }

    protected DataEncryptionParameters getDataEncryptionParameters(Assertion samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) {
        DataEncryptionParameters dataEncParams = new DataEncryptionParameters();
        dataEncParams.setAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        return dataEncParams;
    }

    protected KeyEncryptionParameters getKeyEncryptionParameters(Object samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, Credential credential) {
        KeyEncryptionParameters keyEncParams = new KeyEncryptionParameters();
        keyEncParams.setRecipient(adaptor.getEntityId());
        keyEncParams.setEncryptionCredential(credential);
        keyEncParams.setAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        return keyEncParams;
    }

    protected Credential getKeyEncryptionCredential(String peerEntityId, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService service) throws Exception {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        BasicEncryptionConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultEncryptionConfiguration();
        if (this.overrideBlackListedEncryptionAlgorithms != null && !this.overrideBlackListedEncryptionAlgorithms.isEmpty()) {
            config.setBlacklistedAlgorithms((Collection)this.overrideBlackListedEncryptionAlgorithms);
        }
        if (this.overrideWhiteListedAlgorithms != null && !this.overrideWhiteListedAlgorithms.isEmpty()) {
            config.setWhitelistedAlgorithms((Collection)this.overrideWhiteListedAlgorithms);
        }
        if (this.overrideDataEncryptionAlgorithms != null && !this.overrideDataEncryptionAlgorithms.isEmpty()) {
            config.setDataEncryptionAlgorithms(this.overrideDataEncryptionAlgorithms);
        }
        if (this.overrideKeyEncryptionAlgorithms != null && !this.overrideKeyEncryptionAlgorithms.isEmpty()) {
            config.setKeyTransportEncryptionAlgorithms(this.overrideKeyEncryptionAlgorithms);
        }
        LOGGER.debug("Encryption blacklisted algorithms: [{}]", (Object)config.getBlacklistedAlgorithms());
        LOGGER.debug("Encryption key algorithms: [{}]", (Object)config.getKeyTransportEncryptionAlgorithms());
        LOGGER.debug("Signature data algorithms: [{}]", (Object)config.getDataEncryptionAlgorithms());
        LOGGER.debug("Encryption whitelisted algorithms: [{}]", (Object)config.getWhitelistedAlgorithms());
        MetadataCredentialResolver kekCredentialResolver = new MetadataCredentialResolver();
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new RSAKeyValueProvider());
        providers.add(new DSAKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        providers.add(new DEREncodedKeyValueProvider());
        providers.add(new KeyInfoReferenceProvider());
        BasicProviderKeyInfoCredentialResolver keyInfoResolver = new BasicProviderKeyInfoCredentialResolver(providers);
        kekCredentialResolver.setKeyInfoCredentialResolver((KeyInfoCredentialResolver)keyInfoResolver);
        RoleDescriptorResolver roleDescriptorResolver = SamlIdPUtils.getRoleDescriptorResolver((SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (boolean)idp.getMetadata().isRequireValidMetadata());
        kekCredentialResolver.setRoleDescriptorResolver(roleDescriptorResolver);
        kekCredentialResolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{config}));
        criteriaSet.add((Object)new EntityIdCriterion(peerEntityId));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        LOGGER.debug("Attempting to resolve the encryption key for entity id [{}]", (Object)peerEntityId);
        return kekCredentialResolver.resolveSingle(criteriaSet);
    }
}

