/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.ecp;

import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectSignatureValidator;
import org.apereo.cas.util.Pac4jUtils;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.ecp.Response;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;

public class ECPProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ECPProfileHandlerController.class);
    private final SamlProfileObjectBuilder<? extends SAMLObject> samlEcpFaultResponseBuilder;

    public ECPProfileHandlerController(SamlIdPObjectSigner samlObjectSigner, ParserPool parserPool, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver, OpenSamlConfigBean configBean, SamlProfileObjectBuilder<Response> responseBuilder, SamlProfileObjectBuilder<? extends SAMLObject> samlEcpFaultResponseBuilder, CasConfigurationProperties casProperties, SamlObjectSignatureValidator samlObjectSignatureValidator, Service callbackService) {
        super(samlObjectSigner, parserPool, authenticationSystemSupport, servicesManager, webApplicationServiceFactory, samlRegisteredServiceCachingMetadataResolver, configBean, responseBuilder, casProperties, samlObjectSignatureValidator, callbackService);
        this.samlEcpFaultResponseBuilder = samlEcpFaultResponseBuilder;
    }

    @PostMapping(path={"/idp/profile/SAML2/SOAP/ECP"}, consumes={"text/xml", "application/vnd.paos+xml"}, produces={"text/xml", "application/vnd.paos+xml"})
    public void handleEcpRequest(HttpServletResponse response, HttpServletRequest request) {
        MessageContext soapContext = this.decodeSoapRequest(request);
        Credential credential = this.extractBasicAuthenticationCredential(request, response);
        if (credential == null) {
            LOGGER.error("Credentials could not be extracted from the SAML ECP request");
            return;
        }
        if (soapContext == null) {
            LOGGER.error("SAML ECP request could not be determined from the authentication request");
            return;
        }
        this.handleEcpRequest(response, request, soapContext, credential, "urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
    }

    protected void handleEcpRequest(HttpServletResponse response, HttpServletRequest request, MessageContext soapContext, Credential credential, String binding) {
        LOGGER.debug("Handling ECP request for SOAP context [{}]", (Object)soapContext);
        Envelope envelope = ((SOAP11Context)soapContext.getSubcontext(SOAP11Context.class)).getEnvelope();
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)envelope);
        AuthnRequest authnRequest = (AuthnRequest)soapContext.getMessage();
        Pair authenticationContext = Pair.of((Object)authnRequest, (Object)soapContext);
        try {
            LOGGER.debug("Verifying ECP authentication request [{}]", (Object)authnRequest);
            Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> serviceRequest = this.verifySamlAuthenticationRequest((Pair<? extends SignableSAMLObject, MessageContext>)authenticationContext, request);
            LOGGER.debug("Attempting to authenticate ECP request for credential id [{}]", (Object)credential.getId());
            Authentication authentication = this.authenticateEcpRequest(credential, (Pair<AuthnRequest, MessageContext>)authenticationContext);
            LOGGER.debug("Authenticated [{}] successfully with authenticated principal [{}]", (Object)credential.getId(), (Object)authentication.getPrincipal());
            LOGGER.debug("Building ECP SAML response for [{}]", (Object)credential.getId());
            String issuer = SamlIdPUtils.getIssuerFromSamlRequest((RequestAbstractType)authnRequest);
            Service service = this.webApplicationServiceFactory.createService(issuer);
            Assertion casAssertion = this.buildCasAssertion(authentication, service, (RegisteredService)serviceRequest.getKey(), new LinkedHashMap<String, Object>());
            LOGGER.debug("CAS assertion to use for building ECP SAML response is [{}]", (Object)casAssertion);
            this.buildSamlResponse(response, request, (Pair<AuthnRequest, MessageContext>)authenticationContext, casAssertion, binding);
        }
        catch (AuthenticationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String error = e.getHandlerErrors().values().stream().map(Throwable::getMessage).filter(Objects::nonNull).collect(Collectors.joining(","));
            this.buildEcpFaultResponse(response, request, (Pair<RequestAbstractType, String>)Pair.of((Object)authnRequest, (Object)error));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.buildEcpFaultResponse(response, request, (Pair<RequestAbstractType, String>)Pair.of((Object)authnRequest, (Object)e.getMessage()));
        }
    }

    protected void buildEcpFaultResponse(HttpServletResponse response, HttpServletRequest request, Pair<RequestAbstractType, String> authenticationContext) {
        request.setAttribute("samlError", authenticationContext.getValue());
        this.samlEcpFaultResponseBuilder.build((RequestAbstractType)authenticationContext.getKey(), request, response, null, null, null, "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", null);
    }

    protected Authentication authenticateEcpRequest(Credential credential, Pair<AuthnRequest, MessageContext> authnRequest) {
        String issuer = SamlIdPUtils.getIssuerFromSamlRequest((RequestAbstractType)((RequestAbstractType)authnRequest.getKey()));
        LOGGER.debug("Located issuer [{}] from request prior to authenticating [{}]", (Object)issuer, (Object)credential.getId());
        Service service = this.webApplicationServiceFactory.createService(issuer);
        LOGGER.debug("Executing authentication request for service [{}] on behalf of credential id [{}]", (Object)service, (Object)credential.getId());
        AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(service, new Credential[]{credential});
        return authenticationResult.getAuthentication();
    }

    private Credential extractBasicAuthenticationCredential(HttpServletRequest request, HttpServletResponse response) {
        try {
            BasicAuthExtractor extractor = new BasicAuthExtractor();
            J2EContext webContext = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
            UsernamePasswordCredentials credentials = extractor.extract((WebContext)webContext);
            if (credentials != null) {
                LOGGER.debug("Received basic authentication ECP request from credentials [{}]", (Object)credentials);
                return new UsernamePasswordCredential(credentials.getUsername(), credentials.getPassword());
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

