/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectSignatureValidator;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;

public class SSOSamlProfileCallbackHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOSamlProfileCallbackHandlerController.class);
    private final AbstractUrlBasedTicketValidator ticketValidator;

    public SSOSamlProfileCallbackHandlerController(SamlIdPObjectSigner samlObjectSigner, ParserPool parserPool, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver, OpenSamlConfigBean configBean, SamlProfileObjectBuilder<Response> responseBuilder, CasConfigurationProperties casProperties, SamlObjectSignatureValidator samlObjectSignatureValidator, AbstractUrlBasedTicketValidator ticketValidator, Service callbackService) {
        super(samlObjectSigner, parserPool, authenticationSystemSupport, servicesManager, webApplicationServiceFactory, samlRegisteredServiceCachingMetadataResolver, configBean, responseBuilder, casProperties, samlObjectSignatureValidator, callbackService);
        this.ticketValidator = ticketValidator;
    }

    @GetMapping(path={"/idp/profile/SAML2/Callback"})
    protected void handleCallbackProfileRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        LOGGER.info("Received SAML callback profile request [{}]", (Object)request.getRequestURI());
        AuthnRequest authnRequest = this.retrieveSamlAuthenticationRequestFromHttpRequest(request);
        if (authnRequest == null) {
            LOGGER.error("Can not validate the request because the original Authn request can not be found.");
            response.setStatus(403);
            return;
        }
        String ticket = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)"ticket");
        if (StringUtils.isBlank((CharSequence)ticket)) {
            LOGGER.error("Can not validate the request because no [{}] is provided via the request", (Object)"ticket");
            response.setStatus(403);
            return;
        }
        Pair<AuthnRequest, MessageContext> authenticationContext = SSOSamlProfileCallbackHandlerController.buildAuthenticationContextPair(request, authnRequest);
        Assertion assertion = this.validateRequestAndBuildCasAssertion(response, request, authenticationContext);
        String binding = this.determineProfileBinding(authenticationContext, assertion);
        this.buildSamlResponse(response, request, authenticationContext, assertion, binding);
    }

    protected static Pair<AuthnRequest, MessageContext> buildAuthenticationContextPair(HttpServletRequest request, AuthnRequest authnRequest) {
        MessageContext<SAMLObject> messageContext = SSOSamlProfileCallbackHandlerController.bindRelayStateParameter(request);
        return Pair.of((Object)authnRequest, messageContext);
    }

    private static MessageContext<SAMLObject> bindRelayStateParameter(HttpServletRequest request) {
        MessageContext messageContext = new MessageContext();
        String relayState = request.getParameter("RelayState");
        LOGGER.debug("Relay state is [{}]", (Object)relayState);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)relayState);
        return messageContext;
    }

    private Assertion validateRequestAndBuildCasAssertion(HttpServletResponse response, HttpServletRequest request, Pair<AuthnRequest, MessageContext> pair) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)pair.getKey();
        String ticket = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)"ticket");
        this.ticketValidator.setRenew(authnRequest.isForceAuthn().booleanValue());
        String serviceUrl = this.constructServiceUrl(request, response, pair);
        LOGGER.trace("Created service url for validation: [{}]", (Object)serviceUrl);
        Assertion assertion = this.ticketValidator.validate(ticket, serviceUrl);
        this.logCasValidationAssertion(assertion);
        return assertion;
    }

    protected String determineProfileBinding(Pair<AuthnRequest, MessageContext> authenticationContext, Assertion assertion) {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> pair = this.getRegisteredServiceAndFacade(authnRequest);
        SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue();
        String binding = (String)StringUtils.defaultIfBlank((CharSequence)authnRequest.getProtocolBinding(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        LOGGER.debug("Determined authentication request binding is [{}], issued by [{}]", (Object)binding, (Object)authnRequest.getIssuer().getValue());
        String entityId = facade.getEntityId();
        LOGGER.debug("Checking metadata for [{}] to see if binding [{}] is supported", (Object)entityId, (Object)binding);
        AssertionConsumerService svc = facade.getAssertionConsumerService(binding);
        LOGGER.debug("Binding [{}] is supported by [{}]", (Object)svc.getBinding(), (Object)entityId);
        return binding;
    }
}

