/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.assertion;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.util.RandomUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlAssertionBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Assertion> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAssertionBuilder.class);
    private static final long serialVersionUID = -3945938960014421135L;
    private final CasConfigurationProperties casProperties;
    private final SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder;
    private final SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder;
    private final SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder;
    private final SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder;
    private final transient SamlIdPObjectSigner samlObjectSigner;

    public SamlProfileSamlAssertionBuilder(OpenSamlConfigBean configBean, CasConfigurationProperties casProperties, SamlProfileObjectBuilder<AuthnStatement> samlProfileSamlAuthNStatementBuilder, SamlProfileObjectBuilder<AttributeStatement> samlProfileSamlAttributeStatementBuilder, SamlProfileObjectBuilder<Subject> samlProfileSamlSubjectBuilder, SamlProfileObjectBuilder<Conditions> samlProfileSamlConditionsBuilder, SamlIdPObjectSigner samlObjectSigner) {
        super(configBean);
        this.samlProfileSamlAuthNStatementBuilder = samlProfileSamlAuthNStatementBuilder;
        this.samlProfileSamlAttributeStatementBuilder = samlProfileSamlAttributeStatementBuilder;
        this.samlProfileSamlSubjectBuilder = samlProfileSamlSubjectBuilder;
        this.samlProfileSamlConditionsBuilder = samlProfileSamlConditionsBuilder;
        this.samlObjectSigner = samlObjectSigner;
        this.casProperties = casProperties;
    }

    @Override
    public Assertion build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object casAssertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        ArrayList<Object> statements = new ArrayList<Object>();
        AuthnStatement authnStatement = this.samlProfileSamlAuthNStatementBuilder.build(authnRequest, request, response, casAssertion, service, adaptor, binding, messageContext);
        statements.add(authnStatement);
        AttributeStatement attrStatement = this.samlProfileSamlAttributeStatementBuilder.build(authnRequest, request, response, casAssertion, service, adaptor, binding, messageContext);
        if (!attrStatement.getAttributes().isEmpty() || !attrStatement.getEncryptedAttributes().isEmpty()) {
            statements.add(attrStatement);
        }
        String id = '_' + String.valueOf(Math.abs(RandomUtils.getNativeInstance().nextLong()));
        Assertion assertion = this.newAssertion(statements, this.casProperties.getAuthn().getSamlIdp().getEntityId(), ZonedDateTime.now(ZoneOffset.UTC), id);
        assertion.setSubject(this.samlProfileSamlSubjectBuilder.build(authnRequest, request, response, casAssertion, service, adaptor, binding, messageContext));
        assertion.setConditions(this.samlProfileSamlConditionsBuilder.build(authnRequest, request, response, casAssertion, service, adaptor, binding, messageContext));
        this.signAssertion(assertion, request, response, service, adaptor, binding, authnRequest);
        return assertion;
    }

    protected void signAssertion(Assertion assertion, HttpServletRequest request, HttpServletResponse response, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, RequestAbstractType authnRequest) throws SamlException {
        if (service.isSignAssertions()) {
            LOGGER.debug("SAML registered service [{}] requires assertions to be signed", (Object)adaptor.getEntityId());
            this.samlObjectSigner.encode(assertion, service, adaptor, response, request, binding, authnRequest);
        } else {
            LOGGER.debug("SAML registered service [{}] does not require assertions to be signed", (Object)adaptor.getEntityId());
        }
    }
}

