/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.audit;

import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRequestAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRequestAuditResourceResolver.class);

    public String[] resolveFrom(JoinPoint joinPoint, Object returnValue) {
        if (returnValue instanceof Pair) {
            return this.getAuditResourceFromSamlRequest((Pair)returnValue);
        }
        return new String[0];
    }

    private String[] getAuditResourceFromSamlRequest(Pair result) {
        XMLObject returnValue = (XMLObject)result.getLeft();
        if (returnValue instanceof AuthnRequest) {
            return this.getAuditResourceFromSamlAuthnRequest((AuthnRequest)returnValue);
        }
        if (returnValue instanceof LogoutRequest) {
            return this.getAuditResourceFromSamlLogoutRequest((LogoutRequest)returnValue);
        }
        return new String[0];
    }

    private String[] getAuditResourceFromSamlLogoutRequest(LogoutRequest returnValue) {
        LogoutRequest request = returnValue;
        String result = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("issuer", (Object)request.getIssuer().getValue()).toString();
        return new String[]{result};
    }

    private String[] getAuditResourceFromSamlAuthnRequest(AuthnRequest returnValue) {
        AuthnRequest request = returnValue;
        String result = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("issuer", (Object)request.getIssuer().getValue()).append("binding", (Object)request.getProtocolBinding()).toString();
        return new String[]{result};
    }
}

