/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.audit;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlResponseAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlResponseAuditResourceResolver.class);

    public String[] resolveFrom(JoinPoint joinPoint, Object returnValue) {
        if (returnValue instanceof Response) {
            return this.getPrincipalIdFromSamlResponse((Response)returnValue);
        }
        if (returnValue instanceof Envelope) {
            return this.getPrincipalIdFromSamlEcpResponse((Envelope)returnValue);
        }
        LOGGER.error("Could not determine the SAML response in the returned value");
        return new String[0];
    }

    private String[] getPrincipalIdFromSamlEcpResponse(Envelope envelope) {
        List objects = envelope.getBody().getUnknownXMLObjects();
        if (objects.isEmpty()) {
            return new String[0];
        }
        XMLObject object = (XMLObject)objects.get(0);
        if (object instanceof Response) {
            return this.getPrincipalIdFromSamlResponse((Response)object);
        }
        if (object instanceof Fault) {
            return this.getPrincipalIdFromSamlEcpFault((Fault)object);
        }
        return new String[0];
    }

    private String[] getPrincipalIdFromSamlResponse(Response response) {
        String result = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("issuer", (Object)response.getIssuer().getValue()).append("destination", (Object)response.getDestination()).toString();
        return new String[]{result};
    }

    private String[] getPrincipalIdFromSamlEcpFault(Fault fault) {
        String result = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("actor", (Object)fault.getActor().getValue()).append("message", (Object)fault.getMessage().getValue()).toString();
        return new String[]{result};
    }
}

