/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.attr;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPResponseProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SamlProfileSamlAttributeStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AttributeStatement> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAttributeStatementBuilder.class);
    private static final long serialVersionUID = 1815697787562189088L;
    @Autowired
    private CasConfigurationProperties casProperties;
    private final transient ProtocolAttributeEncoder samlAttributeEncoder;

    public SamlProfileSamlAttributeStatementBuilder(OpenSamlConfigBean configBean, ProtocolAttributeEncoder samlAttributeEncoder) {
        super(configBean);
        this.samlAttributeEncoder = samlAttributeEncoder;
    }

    @Override
    public AttributeStatement build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildAttributeStatement(assertion, authnRequest, service, adaptor, messageContext);
    }

    private AttributeStatement buildAttributeStatement(Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext messageContext) throws SamlException {
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        HashMap attributes = new HashMap(assertion.getAttributes());
        attributes.putAll(assertion.getPrincipal().getAttributes());
        Map encodedAttrs = this.samlAttributeEncoder.encodeAttributes(attributes, (RegisteredService)service);
        SamlIdPResponseProperties resp = this.casProperties.getAuthn().getSamlIdp().getResponse();
        HashMap nameFormats = new HashMap(resp.configureAttributeNameFormats());
        nameFormats.putAll(service.getAttributeNameFormats());
        return this.newAttributeStatement(encodedAttrs, service.getAttributeFriendlyNames(), nameFormats, resp.getDefaultAttributeNameFormat());
    }
}

