/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.conditions;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class SamlProfileSamlConditionsBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Conditions> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlConditionsBuilder.class);
    private static final long serialVersionUID = 126393045912318783L;
    @Autowired
    private CasConfigurationProperties casProperties;

    public SamlProfileSamlConditionsBuilder(OpenSamlConfigBean configBean) {
        super(configBean);
    }

    @Override
    public Conditions build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildConditions(authnRequest, assertion, service, adaptor, messageContext);
    }

    protected Conditions buildConditions(RequestAbstractType authnRequest, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext messageContext) throws SamlException {
        ZonedDateTime currentDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        int skewAllowance = this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance();
        if (skewAllowance <= 0) {
            skewAllowance = this.casProperties.getSamlCore().getSkewAllowance();
        }
        ArrayList<String> audienceUrls = new ArrayList<String>();
        audienceUrls.add(adaptor.getEntityId());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service.getAssertionAudiences())) {
            Set audiences = StringUtils.commaDelimitedListToSet((String)service.getAssertionAudiences());
            audienceUrls.addAll(audiences);
        }
        Conditions conditions = this.newConditions(currentDateTime, currentDateTime.plusSeconds(skewAllowance), audienceUrls.toArray(new String[0]));
        return conditions;
    }
}

