/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSamlResponseEncoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSamlResponseEncoder.class);
    protected final VelocityEngine velocityEngineFactory;
    protected final SamlRegisteredServiceServiceProviderMetadataFacade adaptor;
    protected final HttpServletResponse httpResponse;
    protected final HttpServletRequest httpRequest;

    public final Response encode(RequestAbstractType authnRequest, Response samlResponse, String relayState) throws SamlException {
        if (this.httpResponse != null) {
            BaseSAML2MessageEncoder encoder = this.getMessageEncoderInstance();
            encoder.setHttpServletResponse(this.httpResponse);
            MessageContext ctx = this.getEncoderMessageContext(authnRequest, samlResponse, relayState);
            encoder.setMessageContext(ctx);
            this.finalizeEncode(authnRequest, encoder, samlResponse, relayState);
        }
        return samlResponse;
    }

    protected MessageContext getEncoderMessageContext(RequestAbstractType authnRequest, Response samlResponse, String relayState) {
        MessageContext ctx = new MessageContext();
        ctx.setMessage((Object)samlResponse);
        SAMLBindingSupport.setRelayState((MessageContext)ctx, (String)relayState);
        SamlIdPUtils.preparePeerEntitySamlEndpointContext((RequestAbstractType)authnRequest, (MessageContext)ctx, (SamlRegisteredServiceServiceProviderMetadataFacade)this.adaptor, (String)this.getBinding());
        SAMLSelfEntityContext self = (SAMLSelfEntityContext)ctx.getSubcontext(SAMLSelfEntityContext.class, true);
        self.setEntityId(samlResponse.getIssuer().getValue());
        return ctx;
    }

    protected void finalizeEncode(RequestAbstractType authnRequest, BaseSAML2MessageEncoder encoder, Response samlResponse, String relayState) throws Exception {
        encoder.initialize();
        encoder.encode();
    }

    protected abstract String getBinding();

    protected abstract BaseSAML2MessageEncoder getMessageEncoderInstance();

    @Generated
    public BaseSamlResponseEncoder(VelocityEngine velocityEngineFactory, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletResponse httpResponse, HttpServletRequest httpRequest) {
        this.velocityEngineFactory = velocityEngineFactory;
        this.adaptor = adaptor;
        this.httpResponse = httpResponse;
        this.httpRequest = httpRequest;
    }
}

