/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import com.google.common.collect.Sets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPResponseProperties;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.util.crypto.CertUtils;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.credential.AbstractCredential;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SamlIdPObjectSigner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPObjectSigner.class);
    protected final List overrideSignatureReferenceDigestMethods;
    protected final List overrideSignatureAlgorithms;
    protected final List overrideBlackListedSignatureAlgorithms;
    protected final List overrideWhiteListedAlgorithms;
    private final MetadataResolver casSamlIdPMetadataResolver;
    private final CasConfigurationProperties casProperties;
    private final SamlIdPMetadataLocator samlIdPMetadataLocator;

    public <T extends SAMLObject> T encode(T samlObject, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletResponse response, HttpServletRequest request, String binding, RequestAbstractType authnRequest) throws SamlException {
        LOGGER.debug("Attempting to encode [{}] for [{}]", (Object)samlObject.getClass().getName(), (Object)adaptor.getEntityId());
        MessageContext outboundContext = new MessageContext();
        this.prepareOutboundContext(samlObject, adaptor, outboundContext, binding, authnRequest);
        this.prepareSecurityParametersContext(adaptor, outboundContext, service);
        this.prepareEndpointURLSchemeSecurityHandler(outboundContext);
        this.prepareSamlOutboundDestinationHandler(outboundContext);
        this.prepareSamlOutboundProtocolMessageSigningHandler(outboundContext);
        return samlObject;
    }

    protected <T extends SAMLObject> void prepareSamlOutboundProtocolMessageSigningHandler(MessageContext<T> outboundContext) throws Exception {
        LOGGER.debug("Attempting to sign the outbound SAML message...");
        SAMLOutboundProtocolMessageSigningHandler handler = new SAMLOutboundProtocolMessageSigningHandler();
        handler.setSignErrorResponses(this.casProperties.getAuthn().getSamlIdp().getResponse().isSignError());
        handler.invoke(outboundContext);
        LOGGER.debug("Signed SAML message successfully");
    }

    protected <T extends SAMLObject> void prepareSamlOutboundDestinationHandler(MessageContext<T> outboundContext) throws Exception {
        SAMLOutboundDestinationHandler handlerDest = new SAMLOutboundDestinationHandler();
        handlerDest.initialize();
        handlerDest.invoke(outboundContext);
    }

    protected <T extends SAMLObject> void prepareEndpointURLSchemeSecurityHandler(MessageContext<T> outboundContext) throws Exception {
        EndpointURLSchemeSecurityHandler handlerEnd = new EndpointURLSchemeSecurityHandler();
        handlerEnd.initialize();
        handlerEnd.invoke(outboundContext);
    }

    protected <T extends SAMLObject> void prepareSecurityParametersContext(SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext<T> outboundContext, SamlRegisteredService service) throws SAMLException {
        SecurityParametersContext secParametersContext = (SecurityParametersContext)outboundContext.getSubcontext(SecurityParametersContext.class, true);
        SPSSODescriptor roleDesc = adaptor.getSsoDescriptor();
        SignatureSigningParameters signingParameters = this.buildSignatureSigningParameters((RoleDescriptor)roleDesc, service);
        secParametersContext.setSignatureSigningParameters(signingParameters);
    }

    protected <T extends SAMLObject> void prepareOutboundContext(T samlObject, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext<T> outboundContext, String binding, RequestAbstractType authnRequest) throws SamlException {
        LOGGER.debug("Outbound saml object to use is [{}]", (Object)samlObject.getClass().getName());
        outboundContext.setMessage(samlObject);
        SamlIdPUtils.preparePeerEntitySamlEndpointContext((RequestAbstractType)authnRequest, outboundContext, (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (String)binding);
    }

    protected SignatureSigningParameters buildSignatureSigningParameters(RoleDescriptor descriptor, SamlRegisteredService service) {
        CriteriaSet criteria = new CriteriaSet();
        SignatureSigningConfiguration signatureSigningConfiguration = this.getSignatureSigningConfiguration(descriptor, service);
        criteria.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{signatureSigningConfiguration}));
        criteria.add((Object)new RoleDescriptorCriterion(descriptor));
        SAMLMetadataSignatureSigningParametersResolver resolver = new SAMLMetadataSignatureSigningParametersResolver();
        LOGGER.debug("Resolving signature signing parameters for [{}]", (Object)descriptor.getElementQName().getLocalPart());
        SignatureSigningParameters params = resolver.resolveSingle(criteria);
        LOGGER.debug("Created signature signing parameters.\nSignature algorithm: [{}]\nSignature canonicalization algorithm: [{}]\nSignature reference digest methods: [{}]", new Object[]{params.getSignatureAlgorithm(), params.getSignatureCanonicalizationAlgorithm(), params.getSignatureReferenceDigestMethod()});
        return params;
    }

    protected SignatureSigningConfiguration getSignatureSigningConfiguration(RoleDescriptor roleDescriptor, SamlRegisteredService service) throws Exception {
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        if (this.overrideBlackListedSignatureAlgorithms != null && !samlIdp.getAlgs().getOverrideBlackListedSignatureSigningAlgorithms().isEmpty()) {
            config.setBlacklistedAlgorithms((Collection)this.overrideBlackListedSignatureAlgorithms);
        }
        if (this.overrideSignatureAlgorithms != null && !this.overrideSignatureAlgorithms.isEmpty()) {
            config.setSignatureAlgorithms(this.overrideSignatureAlgorithms);
        }
        if (this.overrideSignatureReferenceDigestMethods != null && !this.overrideSignatureReferenceDigestMethods.isEmpty()) {
            config.setSignatureReferenceDigestMethods(this.overrideSignatureReferenceDigestMethods);
        }
        if (this.overrideWhiteListedAlgorithms != null && !this.overrideWhiteListedAlgorithms.isEmpty()) {
            config.setWhitelistedAlgorithms((Collection)this.overrideWhiteListedAlgorithms);
        }
        if (StringUtils.isNotBlank((CharSequence)samlIdp.getAlgs().getOverrideSignatureCanonicalizationAlgorithm())) {
            config.setSignatureCanonicalizationAlgorithm(samlIdp.getAlgs().getOverrideSignatureCanonicalizationAlgorithm());
        }
        LOGGER.debug("Signature signing blacklisted algorithms: [{}]", (Object)config.getBlacklistedAlgorithms());
        LOGGER.debug("Signature signing signature algorithms: [{}]", (Object)config.getSignatureAlgorithms());
        LOGGER.debug("Signature signing signature canonicalization algorithm: [{}]", (Object)config.getSignatureCanonicalizationAlgorithm());
        LOGGER.debug("Signature signing whitelisted algorithms: [{}]", (Object)config.getWhitelistedAlgorithms());
        LOGGER.debug("Signature signing reference digest methods: [{}]", (Object)config.getSignatureReferenceDigestMethods());
        PrivateKey privateKey = this.getSigningPrivateKey();
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        MetadataCredentialResolver kekCredentialResolver = new MetadataCredentialResolver();
        RoleDescriptorResolver roleDescriptorResolver = SamlIdPUtils.getRoleDescriptorResolver((MetadataResolver)this.casSamlIdPMetadataResolver, (boolean)idp.getMetadata().isRequireValidMetadata());
        kekCredentialResolver.setRoleDescriptorResolver(roleDescriptorResolver);
        kekCredentialResolver.setKeyInfoCredentialResolver(DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        kekCredentialResolver.initialize();
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{config}));
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        criteriaSet.add((Object)new EntityIdCriterion(this.casProperties.getAuthn().getSamlIdp().getEntityId()));
        criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        LinkedHashSet credentials = Sets.newLinkedHashSet((Iterable)kekCredentialResolver.resolve(criteriaSet));
        ArrayList creds = new ArrayList();
        credentials.forEach(c -> {
            AbstractCredential cred = this.getResolvedSigningCredential((Credential)c, privateKey, service);
            if (cred != null) {
                creds.add(cred);
            }
        });
        config.setSigningCredentials(creds);
        LOGGER.debug("Signature signing credentials configured with [{}] credentials", (Object)creds.size());
        return config;
    }

    private AbstractCredential getResolvedSigningCredential(Credential c, PrivateKey privateKey, SamlRegisteredService service) {
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        try {
            SamlIdPResponseProperties.SignatureCredentialTypes credType = SamlIdPResponseProperties.SignatureCredentialTypes.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)service.getSigningCredentialType(), (CharSequence)samlIdp.getResponse().getCredentialType().name())).toUpperCase());
            LOGGER.debug("Requested credential type [{}] is found for service [{}]", (Object)credType, (Object)service);
            switch (credType) {
                case BASIC: {
                    LOGGER.debug("Building basic credential signing key [{}] based on requested credential type", (Object)credType);
                    return new BasicCredential(c.getPublicKey(), privateKey);
                }
            }
            if (c instanceof BasicX509Credential) {
                X509Certificate certificate = ((BasicX509Credential)BasicX509Credential.class.cast(c)).getEntityCertificate();
                LOGGER.debug("Locating signature signing certificate from credential [{}]", (Object)CertUtils.toString((X509Certificate)certificate));
                return new BasicX509Credential(certificate, privateKey);
            }
            Resource signingCert = this.samlIdPMetadataLocator.getSigningCertificate();
            LOGGER.debug("Locating signature signing certificate file from [{}]", (Object)signingCert);
            X509Certificate certificate = SamlUtils.readCertificate((Resource)signingCert);
            return new BasicX509Credential(certificate, privateKey);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected PrivateKey getSigningPrivateKey() throws Exception {
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        Resource signingKey = this.samlIdPMetadataLocator.getSigningKey();
        PrivateKeyFactoryBean privateKeyFactoryBean = new PrivateKeyFactoryBean();
        privateKeyFactoryBean.setLocation((Resource)new FileSystemResource(signingKey.getFile()));
        privateKeyFactoryBean.setAlgorithm(samlIdp.getMetadata().getPrivateKeyAlgName());
        privateKeyFactoryBean.setSingleton(false);
        LOGGER.debug("Locating signature signing key file from [{}]", (Object)signingKey);
        return (PrivateKey)privateKeyFactoryBean.getObject();
    }

    @Generated
    public SamlIdPObjectSigner(List overrideSignatureReferenceDigestMethods, List overrideSignatureAlgorithms, List overrideBlackListedSignatureAlgorithms, List overrideWhiteListedAlgorithms, MetadataResolver casSamlIdPMetadataResolver, CasConfigurationProperties casProperties, SamlIdPMetadataLocator samlIdPMetadataLocator) {
        this.overrideSignatureReferenceDigestMethods = overrideSignatureReferenceDigestMethods;
        this.overrideSignatureAlgorithms = overrideSignatureAlgorithms;
        this.overrideBlackListedSignatureAlgorithms = overrideBlackListedSignatureAlgorithms;
        this.overrideWhiteListedAlgorithms = overrideWhiteListedAlgorithms;
        this.casSamlIdPMetadataResolver = casSamlIdPMetadataResolver;
        this.casProperties = casProperties;
        this.samlIdPMetadataLocator = samlIdPMetadataLocator;
    }
}

