/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.BaseSamlResponseEncoder;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.SAMLArtifactContext;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPArtifactEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlResponseArtifactEncoder
extends BaseSamlResponseEncoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlResponseArtifactEncoder.class);
    private final TicketRegistry ticketRegistry;
    private final SamlArtifactTicketFactory samlArtifactTicketFactory;
    private final RequestAbstractType authnRequest;
    private final SAMLArtifactMap samlArtifactMap;
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;

    public SamlResponseArtifactEncoder(VelocityEngine velocityEngineFactory, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestAbstractType authnRequest, TicketRegistry ticketRegistry, SamlArtifactTicketFactory samlArtifactTicketFactory, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, SAMLArtifactMap samlArtifactMap) {
        super(velocityEngineFactory, adaptor, httpResponse, httpRequest);
        this.ticketRegistry = ticketRegistry;
        this.samlArtifactTicketFactory = samlArtifactTicketFactory;
        this.authnRequest = authnRequest;
        this.samlArtifactMap = samlArtifactMap;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    @Override
    protected String getBinding() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    @Override
    protected BaseSAML2MessageEncoder getMessageEncoderInstance() {
        HTTPArtifactEncoder encoder = new HTTPArtifactEncoder();
        encoder.setVelocityEngine(this.velocityEngineFactory);
        return encoder;
    }

    @Override
    protected void finalizeEncode(RequestAbstractType authnRequest, BaseSAML2MessageEncoder e, Response samlResponse, String relayState) throws Exception {
        HTTPArtifactEncoder encoder = (HTTPArtifactEncoder)e;
        encoder.setArtifactMap(this.samlArtifactMap);
        MessageContext ctx = this.getEncoderMessageContext(authnRequest, samlResponse, relayState);
        this.prepareArtifactContext(samlResponse, ctx);
        encoder.setMessageContext(ctx);
        super.finalizeEncode(authnRequest, (BaseSAML2MessageEncoder)encoder, samlResponse, relayState);
    }

    private void prepareArtifactContext(Response samlResponse, MessageContext ctx) {
        SAMLArtifactContext art = (SAMLArtifactContext)ctx.getSubcontext(SAMLArtifactContext.class, true);
        art.setArtifactType(SAML2ArtifactType0004.TYPE_CODE);
        art.setSourceEntityId(samlResponse.getIssuer().getValue());
        AssertionConsumerService svc = this.adaptor.getAssertionConsumerServiceForArtifactBinding();
        art.setSourceArtifactResolutionServiceEndpointIndex(svc.getIndex());
        art.setSourceArtifactResolutionServiceEndpointURL(svc.getLocation());
    }
}

