/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.response;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.velocity.app.VelocityEngine;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectEncrypter;
import org.apereo.inspektr.audit.annotation.Audit;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseSamlProfileSamlResponseBuilder<T extends XMLObject>
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSamlProfileSamlResponseBuilder.class);
    private static final long serialVersionUID = -1891703354216174875L;
    protected SamlIdPObjectSigner samlObjectSigner;
    protected final VelocityEngine velocityEngineFactory;
    @Autowired
    protected CasConfigurationProperties casProperties;
    private final SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder;
    private final SamlObjectEncrypter samlObjectEncrypter;

    public BaseSamlProfileSamlResponseBuilder(OpenSamlConfigBean openSamlConfigBean, SamlIdPObjectSigner samlObjectSigner, VelocityEngine velocityEngineFactory, SamlProfileObjectBuilder<Assertion> samlProfileSamlAssertionBuilder, SamlObjectEncrypter samlObjectEncrypter) {
        super(openSamlConfigBean);
        this.samlObjectSigner = samlObjectSigner;
        this.velocityEngineFactory = velocityEngineFactory;
        this.samlProfileSamlAssertionBuilder = samlProfileSamlAssertionBuilder;
        this.samlObjectEncrypter = samlObjectEncrypter;
    }

    @Override
    @Audit(action="SAML2_RESPONSE", actionResolverName="SAML2_RESPONSE_ACTION_RESOLVER", resourceResolverName="SAML2_RESPONSE_RESOURCE_RESOLVER")
    public T build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object casAssertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        Assertion assertion = this.buildSamlAssertion(authnRequest, request, response, casAssertion, service, adaptor, binding, messageContext);
        T finalResponse = this.buildResponse(assertion, casAssertion, authnRequest, service, adaptor, request, response, binding, messageContext);
        return this.encodeFinalResponse(request, response, service, adaptor, finalResponse, binding, authnRequest, casAssertion);
    }

    protected T encodeFinalResponse(HttpServletRequest request, HttpServletResponse response, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, T finalResponse, String binding, RequestAbstractType authnRequest, Object assertion) {
        String relayState = request.getParameter("RelayState");
        LOGGER.debug("RelayState is [{}]", (Object)relayState);
        return this.encode(service, finalResponse, response, request, adaptor, relayState, binding, authnRequest, assertion);
    }

    protected Assertion buildSamlAssertion(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object casAssertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) {
        return this.samlProfileSamlAssertionBuilder.build(authnRequest, request, response, casAssertion, service, adaptor, binding, messageContext);
    }

    protected abstract T buildResponse(Assertion var1, Object var2, RequestAbstractType var3, SamlRegisteredService var4, SamlRegisteredServiceServiceProviderMetadataFacade var5, HttpServletRequest var6, HttpServletResponse var7, String var8, MessageContext var9) throws SamlException;

    protected Issuer buildEntityIssuer() {
        Issuer issuer = this.newIssuer(this.casProperties.getAuthn().getSamlIdp().getEntityId());
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        return issuer;
    }

    protected abstract T encode(SamlRegisteredService var1, T var2, HttpServletResponse var3, HttpServletRequest var4, SamlRegisteredServiceServiceProviderMetadataFacade var5, String var6, String var7, RequestAbstractType var8, Object var9) throws SamlException;

    protected SAMLObject encryptAssertion(Assertion assertion, HttpServletRequest request, HttpServletResponse response, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws SamlException {
        if (service.isEncryptAssertions()) {
            LOGGER.debug("SAML service [{}] requires assertions to be encrypted", (Object)adaptor.getEntityId());
            EncryptedAssertion encryptedAssertion = this.samlObjectEncrypter.encode(assertion, service, adaptor, response, request);
            return encryptedAssertion;
        }
        LOGGER.debug("SAML registered service [{}] does not require assertions to be encrypted", (Object)adaptor.getEntityId());
        return assertion;
    }
}

