/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.subject;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlSubjectBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Subject> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlSubjectBuilder.class);
    private static final long serialVersionUID = 4782621942035583007L;
    private final SamlProfileObjectBuilder<NameID> ssoPostProfileSamlNameIdBuilder;
    private final int skewAllowance;

    public SamlProfileSamlSubjectBuilder(OpenSamlConfigBean configBean, SamlProfileObjectBuilder<NameID> ssoPostProfileSamlNameIdBuilder, int skewAllowance) {
        super(configBean);
        this.ssoPostProfileSamlNameIdBuilder = ssoPostProfileSamlNameIdBuilder;
        this.skewAllowance = skewAllowance;
    }

    @Override
    public Subject build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildSubject(request, response, authnRequest, assertion, service, adaptor, binding, messageContext);
    }

    private Subject buildSubject(HttpServletRequest request, HttpServletResponse response, RequestAbstractType authnRequest, Object casAssertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        String location;
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        ZonedDateTime validFromDate = ZonedDateTime.ofInstant(assertion.getValidFromDate().toInstant(), ZoneOffset.UTC);
        LOGGER.debug("Locating the assertion consumer service url for binding [{}]", (Object)binding);
        AssertionConsumerService acs = SamlIdPUtils.determineAssertionConsumerService((RequestAbstractType)authnRequest, (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor, (String)binding);
        String string = location = StringUtils.isBlank((CharSequence)acs.getResponseLocation()) ? acs.getLocation() : acs.getResponseLocation();
        if (StringUtils.isBlank((CharSequence)location)) {
            LOGGER.warn("Subject recipient is not defined from either authentication request or metadata for [{}]", (Object)adaptor.getEntityId());
        }
        NameID nameId = this.getNameIdForService(request, response, authnRequest, service, adaptor, binding, assertion, messageContext);
        Subject subject = this.newSubject(nameId, service.isSkipGeneratingSubjectConfirmationRecipient() ? null : location, service.isSkipGeneratingSubjectConfirmationNotOnOrAfter() ? null : validFromDate.plusSeconds(this.skewAllowance), service.isSkipGeneratingSubjectConfirmationInResponseTo() ? null : authnRequest.getID(), service.isSkipGeneratingSubjectConfirmationNotBefore() ? null : ZonedDateTime.now());
        LOGGER.debug("Created SAML subject [{}]", (Object)subject);
        return subject;
    }

    private NameID getNameIdForService(HttpServletRequest request, HttpServletResponse response, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, Assertion assertion, MessageContext messageContext) {
        if (service.isSkipGeneratingAssertionNameId()) {
            LOGGER.warn("Assertion will skip assigning/generating a nameId based on service [{}]", (Object)service);
            return null;
        }
        return this.ssoPostProfileSamlNameIdBuilder.build(authnRequest, request, response, assertion, service, adaptor, binding, messageContext);
    }
}

