/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPLogoutProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.SSOSamlHttpRequestExtractor;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSamlSLOProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlSLOProfileHandlerController.class);
    private final SSOSamlHttpRequestExtractor samlHttpRequestExtractor;

    public AbstractSamlSLOProfileHandlerController(SamlIdPObjectSigner samlObjectSigner, ParserPool parserPool, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver, OpenSamlConfigBean configBean, SamlProfileObjectBuilder<? extends SAMLObject> responseBuilder, CasConfigurationProperties casProperties, SamlObjectSignatureValidator samlObjectSignatureValidator, SSOSamlHttpRequestExtractor samlHttpRequestExtractor, Service callbackService) {
        super(samlObjectSigner, parserPool, authenticationSystemSupport, servicesManager, webApplicationServiceFactory, samlRegisteredServiceCachingMetadataResolver, configBean, responseBuilder, casProperties, samlObjectSignatureValidator, callbackService);
        this.samlHttpRequestExtractor = samlHttpRequestExtractor;
    }

    protected void handleSloProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder) throws Exception {
        SamlIdPLogoutProperties logout = this.casProperties.getAuthn().getSamlIdp().getLogout();
        if (logout.isSingleLogoutCallbacksDisabled()) {
            LOGGER.info("Processing SAML IdP SLO requests is disabled");
            return;
        }
        Pair<? extends SignableSAMLObject, MessageContext> pair = this.samlHttpRequestExtractor.extract(request, decoder, LogoutRequest.class);
        LogoutRequest logoutRequest = (LogoutRequest)LogoutRequest.class.cast(pair.getKey());
        MessageContext ctx = (MessageContext)pair.getValue();
        if (logout.isForceSignedLogoutRequests() && !SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            throw new SAMLException("Logout request is not signed but should be.");
        }
        if (SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            String entityId = SamlIdPUtils.getIssuerFromSamlRequest((RequestAbstractType)logoutRequest);
            SamlRegisteredService registeredService = (SamlRegisteredService)this.servicesManager.findServiceBy(entityId, SamlRegisteredService.class);
            SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlRegisteredServiceCachingMetadataResolver, (SamlRegisteredService)registeredService, (String)entityId).get();
            this.samlObjectSignatureValidator.verifySamlProfileRequestIfNeeded((RequestAbstractType)logoutRequest, facade, request, ctx);
        }
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)logoutRequest);
        response.sendRedirect(this.casProperties.getServer().getLogoutUrl());
    }
}

