/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.sso;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectSigner;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlObjectSignatureValidator;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.SSOSamlHttpRequestExtractor;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostSimpleSignDecoder;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPRedirectDeflateDecoder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class SSOSamlPostSimpleSignProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOSamlPostSimpleSignProfileHandlerController.class);
    private final SSOSamlHttpRequestExtractor samlHttpRequestExtractor;

    public SSOSamlPostSimpleSignProfileHandlerController(SamlIdPObjectSigner samlObjectSigner, ParserPool parserPool, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, SamlRegisteredServiceCachingMetadataResolver samlRegisteredServiceCachingMetadataResolver, OpenSamlConfigBean configBean, SamlProfileObjectBuilder<Response> responseBuilder, CasConfigurationProperties casProperties, SamlObjectSignatureValidator samlObjectSignatureValidator, SSOSamlHttpRequestExtractor samlHttpRequestExtractor, Service callbackService) {
        super(samlObjectSigner, parserPool, authenticationSystemSupport, servicesManager, webApplicationServiceFactory, samlRegisteredServiceCachingMetadataResolver, configBean, responseBuilder, casProperties, samlObjectSignatureValidator, callbackService);
        this.samlHttpRequestExtractor = samlHttpRequestExtractor;
    }

    @GetMapping(path={"/idp/profile/SAML2/POST-SimpleSign/SSO"})
    protected void handleSaml2ProfileSsoRedirectRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.handleSsoPostProfileRequest(response, request, (BaseHttpServletRequestXMLMessageDecoder)new HTTPRedirectDeflateDecoder());
    }

    @PostMapping(path={"/idp/profile/SAML2/POST-SimpleSign/SSO"})
    protected void handleSaml2ProfileSsoPostRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.handleSsoPostProfileRequest(response, request, (BaseHttpServletRequestXMLMessageDecoder)new HTTPPostSimpleSignDecoder());
    }

    protected void handleSsoPostProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder) throws Exception {
        Pair<? extends SignableSAMLObject, MessageContext> authnRequest = this.samlHttpRequestExtractor.extract(request, decoder, AuthnRequest.class);
        this.initiateAuthenticationRequest(authnRequest, response, request);
    }
}

