/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.metadata;

import java.util.Collection;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.lang.Nullable;

@Endpoint(id="samlIdPRegisteredServiceMetadataCache", enableByDefault=false)
public class SamlRegisteredServiceCachedMetadataEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceCachedMetadataEndpoint.class);
    private final SamlRegisteredServiceCachingMetadataResolver cachingMetadataResolver;
    private final ServicesManager servicesManager;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final OpenSamlConfigBean openSamlConfigBean;

    public SamlRegisteredServiceCachedMetadataEndpoint(CasConfigurationProperties casProperties, SamlRegisteredServiceCachingMetadataResolver cachingMetadataResolver, ServicesManager servicesManager, AuditableExecution registeredServiceAccessStrategyEnforcer, OpenSamlConfigBean openSamlConfigBean) {
        super(casProperties);
        this.cachingMetadataResolver = cachingMetadataResolver;
        this.servicesManager = servicesManager;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.openSamlConfigBean = openSamlConfigBean;
    }

    @DeleteOperation
    public void invalidate(@Nullable String serviceId) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            this.cachingMetadataResolver.invalidate();
        } else {
            SamlRegisteredService registeredService = this.findRegisteredService(serviceId);
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new EntityIdCriterion(serviceId));
            criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
            this.cachingMetadataResolver.invalidate(registeredService, criteriaSet);
        }
    }

    @ReadOperation
    public Map<String, Object> getCachedMetadataObject(String serviceId, @Nullable String entityId) {
        try {
            SamlRegisteredService registeredService = this.findRegisteredService(serviceId);
            String issuer = (String)StringUtils.defaultIfBlank((CharSequence)entityId, (CharSequence)registeredService.getServiceId());
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new EntityIdCriterion(issuer));
            criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
            MetadataResolver metadataResolver = this.cachingMetadataResolver.resolve(registeredService, criteriaSet);
            Spliterator iteration = metadataResolver.resolve((Object)criteriaSet).spliterator();
            return StreamSupport.stream(iteration, false).map(entity -> Pair.of((Object)entity.getEntityID(), (Object)SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)entity).toString())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return CollectionUtils.wrap((String)"error", (Object)e.getMessage());
        }
    }

    private SamlRegisteredService findRegisteredService(String serviceId) {
        Collection matchedServices = null;
        if (NumberUtils.isCreatable((String)serviceId)) {
            long id = Long.parseLong(serviceId);
            matchedServices = this.servicesManager.findServiceBy(svc -> svc instanceof SamlRegisteredService && svc.getId() == id);
        } else {
            matchedServices = this.servicesManager.findServiceBy(svc -> svc instanceof SamlRegisteredService && (svc.getName().equalsIgnoreCase(serviceId) || svc.getServiceId().equalsIgnoreCase(serviceId)));
        }
        if (matchedServices.isEmpty()) {
            throw new IllegalArgumentException("Unable to locate service " + serviceId);
        }
        SamlRegisteredService registeredService = (SamlRegisteredService)matchedServices.iterator().next();
        AuditableContext ctx = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult result = this.registeredServiceAccessStrategyEnforcer.execute(ctx);
        result.throwExceptionIfNeeded();
        return registeredService;
    }
}

