/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPSOAP11Decoder;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

@Controller
public abstract class AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlProfileHandlerController.class);
    protected final SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext;

    protected Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, RequestAbstractType authnRequest) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlProfileHandlerConfigurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
    }

    protected Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, String entityId) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlProfileHandlerConfigurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (String)entityId);
    }

    protected SamlRegisteredService verifySamlRegisteredService(String serviceId) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Could not verify/locate SAML registered service since no serviceId is provided");
        }
        WebApplicationService service = (WebApplicationService)this.samlProfileHandlerConfigurationContext.getWebApplicationServiceFactory().createService(serviceId);
        LOGGER.debug("Checking service access in CAS service registry for [{}]", (Object)service);
        SamlRegisteredService registeredService = (SamlRegisteredService)this.samlProfileHandlerConfigurationContext.getServicesManager().findServiceBy((Service)service, SamlRegisteredService.class);
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("[{}] is not found in the registry or service access is denied. Ensure service is registered in service registry", (Object)serviceId);
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        LOGGER.debug("Located SAML service in the registry as [{}] with the metadata location of [{}]", (Object)registeredService.getServiceId(), (Object)registeredService.getMetadataLocation());
        return registeredService;
    }

    protected AuthnRequest retrieveSamlAuthenticationRequestFromHttpRequest(HttpServletRequest request) throws Exception {
        LOGGER.debug("Retrieving authentication request from scope");
        String requestValue = request.getParameter("SAMLRequest");
        if (StringUtils.isBlank((CharSequence)requestValue)) {
            throw new IllegalArgumentException("SAML request could not be determined from the authentication request");
        }
        byte[] encodedRequest = EncodingUtils.decodeBase64((byte[])requestValue.getBytes(StandardCharsets.UTF_8));
        return (AuthnRequest)XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.samlProfileHandlerConfigurationContext.getOpenSamlConfigBean().getParserPool(), (InputStream)new ByteArrayInputStream(encodedRequest));
    }

    protected Assertion buildCasAssertion(Authentication authentication, Service service, RegisteredService registeredService, Map<String, List<Object>> attributesToCombine) {
        Map attributes = registeredService.getAttributeReleasePolicy().getAttributes(authentication.getPrincipal(), service, registeredService);
        String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(authentication.getPrincipal(), service, registeredService);
        AttributePrincipalImpl principal = new AttributePrincipalImpl(principalId, attributes);
        LinkedHashMap<String, List<Object>> authnAttrs = new LinkedHashMap<String, List<Object>>(authentication.getAttributes());
        authnAttrs.putAll(attributesToCombine);
        return new AssertionImpl((AttributePrincipal)principal, DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate()), null, DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate()), authnAttrs);
    }

    protected Assertion buildCasAssertion(String principal, RegisteredService registeredService, Map<String, Object> attributes) {
        AttributePrincipalImpl p = new AttributePrincipalImpl(principal, attributes);
        return new AssertionImpl((AttributePrincipal)p, DateTimeUtils.dateOf((ChronoZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC)), null, DateTimeUtils.dateOf((ChronoZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC)), attributes);
    }

    protected void logCasValidationAssertion(Assertion assertion) {
        LOGGER.debug("CAS Assertion Valid: [{}]", (Object)assertion.isValid());
        LOGGER.debug("CAS Assertion Principal: [{}]", (Object)assertion.getPrincipal().getName());
        LOGGER.debug("CAS Assertion authentication Date: [{}]", (Object)assertion.getAuthenticationDate());
        LOGGER.debug("CAS Assertion ValidFrom Date: [{}]", (Object)assertion.getValidFromDate());
        LOGGER.debug("CAS Assertion ValidUntil Date: [{}]", (Object)assertion.getValidUntilDate());
        LOGGER.debug("CAS Assertion Attributes: [{}]", (Object)assertion.getAttributes());
        LOGGER.debug("CAS Assertion Principal Attributes: [{}]", (Object)assertion.getPrincipal().getAttributes());
    }

    protected void issueAuthenticationRequestRedirect(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
        String serviceUrl = this.constructServiceUrl(request, response, pair);
        LOGGER.debug("Created service url [{}]", (Object)DigestUtils.abbreviate((String)serviceUrl));
        String initialUrl = CommonUtils.constructRedirectUrl((String)this.samlProfileHandlerConfigurationContext.getCasProperties().getServer().getLoginUrl(), (String)"service", (String)serviceUrl, (boolean)authnRequest.isForceAuthn(), (boolean)authnRequest.isPassive());
        String urlToRedirectTo = this.buildRedirectUrlByRequestedAuthnContext(initialUrl, authnRequest, request);
        LOGGER.debug("Redirecting SAML authN request to [{}]", (Object)urlToRedirectTo);
        DefaultAuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
        authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
    }

    protected Map<String, String> getAuthenticationContextMappings() {
        List authnContexts = this.samlProfileHandlerConfigurationContext.getCasProperties().getAuthn().getSamlIdp().getAuthenticationContextClassMappings();
        return CollectionUtils.convertDirectedListToMap((List)authnContexts);
    }

    protected String buildRedirectUrlByRequestedAuthnContext(String initialUrl, AuthnRequest authnRequest, HttpServletRequest request) {
        List authenticationContextClassMappings = this.samlProfileHandlerConfigurationContext.getCasProperties().getAuthn().getSamlIdp().getAuthenticationContextClassMappings();
        if (authnRequest.getRequestedAuthnContext() == null || authenticationContextClassMappings == null || authenticationContextClassMappings.isEmpty()) {
            return initialUrl;
        }
        Map<String, String> mappings = this.getAuthenticationContextMappings();
        Optional<AuthnContextClassRef> p = authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs().stream().filter(ref -> {
            String clazz = ref.getAuthnContextClassRef();
            return mappings.containsKey(clazz);
        }).findFirst();
        if (p.isPresent()) {
            String mappedClazz = mappings.get(p.get().getAuthnContextClassRef());
            return initialUrl + "&" + this.samlProfileHandlerConfigurationContext.getCasProperties().getAuthn().getMfa().getRequestParameter() + "=" + mappedClazz;
        }
        return initialUrl;
    }

    protected String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair) throws SamlException {
        String string;
        block8: {
            AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
            MessageContext messageContext = (MessageContext)pair.getRight();
            StringWriter writer = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.samlProfileHandlerConfigurationContext.getOpenSamlConfigBean(), (XMLObject)authnRequest);
            try {
                URLBuilder builder = new URLBuilder(this.samlProfileHandlerConfigurationContext.getCallbackService().getId());
                builder.getQueryParams().add(new Pair((Object)"entityId", (Object)SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest)));
                String samlRequest = EncodingUtils.encodeBase64((byte[])writer.toString().getBytes(StandardCharsets.UTF_8));
                builder.getQueryParams().add(new Pair((Object)"SAMLRequest", (Object)samlRequest));
                builder.getQueryParams().add(new Pair((Object)"RelayState", (Object)SAMLBindingSupport.getRelayState((MessageContext)messageContext)));
                String url = builder.buildURL();
                LOGGER.trace("Built service callback url [{}]", (Object)url);
                string = CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)url, (String)this.samlProfileHandlerConfigurationContext.getCasProperties().getServer().getName(), (String)"service", (String)"ticket", (boolean)false);
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            writer.close();
        }
        return string;
    }

    protected void initiateAuthenticationRequest(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.verifySamlAuthenticationRequest(pair, request);
        this.issueAuthenticationRequestRedirect(pair, request, response);
    }

    protected org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> verifySamlAuthenticationRequest(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> authenticationContext, HttpServletRequest request) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        LOGGER.debug("Located issuer [{}] from authentication request", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
        LOGGER.debug("Fetching saml metadata adaptor for [{}]", (Object)issuer);
        Optional adaptor = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.samlProfileHandlerConfigurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
        if (adaptor.isEmpty()) {
            LOGGER.warn("No metadata could be found for [{}]", (Object)issuer);
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor.get();
        this.verifyAuthenticationContextSignature(authenticationContext, request, (RequestAbstractType)authnRequest, facade);
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.samlProfileHandlerConfigurationContext.getOpenSamlConfigBean(), (XMLObject)authnRequest);
        return org.apache.commons.lang3.tuple.Pair.of((Object)registeredService, (Object)facade);
    }

    protected void verifyAuthenticationContextSignature(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> authenticationContext, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws Exception {
        MessageContext ctx = (MessageContext)authenticationContext.getValue();
        this.verifyAuthenticationContextSignature(ctx, request, authnRequest, adaptor);
    }

    protected void verifyAuthenticationContextSignature(MessageContext ctx, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor) throws Exception {
        if (!SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            LOGGER.debug("The authentication context is not signed");
            if (adaptor.isAuthnRequestsSigned()) {
                LOGGER.error("Metadata for [{}] says authentication requests are signed, yet authentication request is not", (Object)adaptor.getEntityId());
                throw new SAMLException("AuthN request is not signed but should be");
            }
            LOGGER.debug("Authentication request is not signed, so there is no need to verify its signature.");
        } else {
            LOGGER.debug("The authentication context is signed; Proceeding to validate signatures...");
            this.samlProfileHandlerConfigurationContext.getSamlObjectSignatureValidator().verifySamlProfileRequestIfNeeded(authnRequest, adaptor, request, ctx);
        }
    }

    protected void buildSamlResponse(HttpServletResponse response, HttpServletRequest request, org.apache.commons.lang3.tuple.Pair<AuthnRequest, MessageContext> authenticationContext, Assertion casAssertion, String binding) {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> pair = this.getRegisteredServiceAndFacade(authnRequest);
        String entityId = ((SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue()).getEntityId();
        LOGGER.debug("Preparing SAML response for [{}]", (Object)entityId);
        this.samlProfileHandlerConfigurationContext.getResponseBuilder().build((RequestAbstractType)authnRequest, request, response, casAssertion, (SamlRegisteredService)pair.getKey(), (SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue(), binding, (MessageContext)authenticationContext.getValue());
        LOGGER.info("Built the SAML response for [{}]", (Object)entityId);
    }

    protected org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> getRegisteredServiceAndFacade(AuthnRequest request) {
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)request);
        LOGGER.debug("Located issuer [{}] from authentication context", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
        LOGGER.debug("Located SAML metadata for [{}]", (Object)registeredService.getServiceId());
        Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(registeredService, (RequestAbstractType)request);
        if (adaptor.isEmpty()) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
        return org.apache.commons.lang3.tuple.Pair.of((Object)registeredService, (Object)facade);
    }

    protected MessageContext decodeSoapRequest(HttpServletRequest request) {
        try {
            HTTPSOAP11Decoder decoder = new HTTPSOAP11Decoder();
            decoder.setParserPool(this.samlProfileHandlerConfigurationContext.getOpenSamlConfigBean().getParserPool());
            decoder.setHttpServletRequest(request);
            BindingDescriptor binding = new BindingDescriptor();
            binding.setId(this.getClass().getName());
            binding.setShortName(this.getClass().getName());
            binding.setSignatureCapable(true);
            binding.setSynchronous(true);
            decoder.setBindingDescriptor(binding);
            decoder.initialize();
            decoder.decode();
            return decoder.getMessageContext();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @ExceptionHandler(value={UnauthorizedServiceException.class})
    public ModelAndView handleUnauthorizedServiceException(HttpServletRequest req, Exception ex) {
        return WebUtils.produceUnauthorizedErrorView();
    }

    @Generated
    public AbstractSamlProfileHandlerController(SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
        this.samlProfileHandlerConfigurationContext = samlProfileHandlerConfigurationContext;
    }

    @Generated
    public SamlProfileHandlerConfigurationContext getSamlProfileHandlerConfigurationContext() {
        return this.samlProfileHandlerConfigurationContext;
    }
}

