/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.artifact;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.util.CollectionUtils;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;

public class Saml1ArtifactResolutionProfileHandlerController
extends AbstractSamlProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Saml1ArtifactResolutionProfileHandlerController.class);

    public Saml1ArtifactResolutionProfileHandlerController(SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
        super(samlProfileHandlerConfigurationContext);
    }

    @PostMapping(path={"/idp/profile/SAML1/SOAP/ArtifactResolution"})
    protected void handlePostRequest(HttpServletResponse response, HttpServletRequest request) {
        MessageContext ctx = this.decodeSoapRequest(request);
        ArtifactResolve artifactMsg = (ArtifactResolve)ctx.getMessage();
        try {
            String issuer = artifactMsg.getIssuer().getValue();
            SamlRegisteredService service = this.verifySamlRegisteredService(issuer);
            Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(service, (RequestAbstractType)artifactMsg);
            if (adaptor.isEmpty()) {
                throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
            }
            SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
            this.verifyAuthenticationContextSignature(ctx, request, (RequestAbstractType)artifactMsg, facade);
            String artifactId = artifactMsg.getArtifact().getArtifact();
            String ticketId = this.getSamlProfileHandlerConfigurationContext().getArtifactTicketFactory().createTicketIdFor(artifactId);
            SamlArtifactTicket ticket = (SamlArtifactTicket)this.getSamlProfileHandlerConfigurationContext().getTicketRegistry().getTicket(ticketId, SamlArtifactTicket.class);
            WebApplicationService issuerService = (WebApplicationService)this.getSamlProfileHandlerConfigurationContext().getWebApplicationServiceFactory().createService(issuer);
            Assertion casAssertion = this.buildCasAssertion(ticket.getTicketGrantingTicket().getAuthentication(), (Service)issuerService, (RegisteredService)service, CollectionUtils.wrap((String)"artifact", (Object)ticket));
            this.getSamlProfileHandlerConfigurationContext().getResponseBuilder().build((RequestAbstractType)artifactMsg, request, response, casAssertion, service, facade, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", ctx);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            request.setAttribute("samlError", (Object)e.getMessage());
            this.getSamlProfileHandlerConfigurationContext().getSamlFaultResponseBuilder().build((RequestAbstractType)artifactMsg, request, response, null, null, null, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", ctx);
        }
    }
}

