/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.attr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPResponseProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.util.Saml20AttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.attr.SamlProfileSamlRegisteredServiceAttributeBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.apereo.cas.util.CollectionUtils;
import org.jasig.cas.client.validation.Assertion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.RequestAbstractType;

public class SamlProfileSamlAttributeStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AttributeStatement> {
    private static final long serialVersionUID = 1815697787562189088L;
    private final transient ProtocolAttributeEncoder samlAttributeEncoder;
    private final SamlIdPProperties samlIdPProperties;
    private final SamlIdPObjectEncrypter samlObjectEncrypter;

    public SamlProfileSamlAttributeStatementBuilder(OpenSamlConfigBean configBean, ProtocolAttributeEncoder samlAttributeEncoder, SamlIdPProperties samlIdPProperties, SamlIdPObjectEncrypter samlObjectEncrypter) {
        super(configBean);
        this.samlAttributeEncoder = samlAttributeEncoder;
        this.samlIdPProperties = samlIdPProperties;
        this.samlObjectEncrypter = samlObjectEncrypter;
    }

    @Override
    public AttributeStatement build(RequestAbstractType authnRequest, HttpServletRequest request, HttpServletResponse response, Object assertion, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, String binding, MessageContext messageContext) throws SamlException {
        return this.buildAttributeStatement(assertion, authnRequest, service, adaptor, messageContext);
    }

    private AttributeStatement buildAttributeStatement(Object casAssertion, RequestAbstractType authnRequest, SamlRegisteredService service, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, MessageContext messageContext) throws SamlException {
        Assertion assertion = (Assertion)Assertion.class.cast(casAssertion);
        HashMap attributes = new HashMap(assertion.getAttributes());
        attributes.putAll(assertion.getPrincipal().getAttributes());
        Map encodedAttrs = this.samlAttributeEncoder.encodeAttributes(attributes, (RegisteredService)service);
        SamlIdPResponseProperties resp = this.samlIdPProperties.getResponse();
        HashMap nameFormats = new HashMap(resp.configureAttributeNameFormats());
        nameFormats.putAll(service.getAttributeNameFormats());
        List globalFriendlyNames = this.samlIdPProperties.getAttributeFriendlyNames();
        HashMap friendlyNames = new HashMap(CollectionUtils.convertDirectedListToMap((List)globalFriendlyNames));
        friendlyNames.putAll(service.getAttributeFriendlyNames());
        SamlProfileSamlRegisteredServiceAttributeBuilder attrBuilder = new SamlProfileSamlRegisteredServiceAttributeBuilder(service, adaptor, messageContext, this.samlObjectEncrypter);
        return this.newAttributeStatement(encodedAttrs, friendlyNames, service.getAttributeValueTypes(), nameFormats, resp.getDefaultAttributeNameFormat(), (Saml20AttributeBuilder)attrBuilder);
    }
}

